package com.biz.crm.business.common.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import static org.apache.ibatis.type.JdbcType.VARCHAR;

/**
 * 标识字段
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
@MappedSuperclass
public class UuidFlagOpEntity extends UuidOpEntity {

  /**
   *
   */
  private static final long serialVersionUID = -3799529180545896952L;

  /**
   * 数据状态（删除状态）
   */
  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Column(name = "del_flag", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '数据状态（删除状态）'")
  private String delFlag;

  /**
   * 数据业务状态（启用状态）
   */
  @TableField(fill = FieldFill.INSERT,updateStrategy = FieldStrategy.NOT_EMPTY, jdbcType = VARCHAR)
  @Column(name = "enable_status", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '数据业务状态（启用状态）'")
  private String enableStatus;

  /**
   * 备注
   */
  @TableField(value = "remark", jdbcType = VARCHAR)
  @Column(name = "remark", columnDefinition = "text COMMENT '备注'")
  private String remark;
}
