package com.biz.crm.business.common.local.filter;

import com.biz.crm.business.common.sdk.constant.CommonConstant;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

/**
 * @author ning.zhang
 * @description logback日志对mdc进行初始化操作
 * @date 2025/06/10
 */
@Slf4j
@Component
public class LogbackMdcFilter implements Filter {

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,
      FilterChain filterChain) throws IOException, ServletException {
    try {
      HttpServletRequest httpServletRequest = (HttpServletRequest) servletRequest;
      String traceId = httpServletRequest.getHeader(CommonConstant.HEADER_TRACE_ID);
      if (StringUtils.isNotBlank(traceId)) {
        MDC.put(CommonConstant.HEADER_TRACE_ID, traceId);
      }
      filterChain.doFilter(servletRequest, servletResponse);
    } finally {
      MDC.clear();
    }
  }
}
