package com.biz.crm.business.common.sdk.service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 生成编码接口
 * 
 * @author jerry7
 * @date 2021-07-27
 */
public interface GenerateCodeService {
  /**
   * 根据编码规则生成一个编码
   * 
   * @param ruleCode 编码规则
   * @return
   */
  default String generateCodeString(String ruleCode) {
    List<String> generateCodeList = this.generateCode(ruleCode, 1);
    String poll = generateCodeList.get(0);
    return poll;
  }

  /**
   * 根据编码规则生成指定数量的编码
   * 
   * @param ruleCode 编码规则
   * @param number 生成数量
   * @return 生成的编码集合
   */
  List<String> generateCode(String ruleCode, int number);

  /**
   * 根据编码规则生成指定数量的编码，并设置长度和有效期
   * 
   * @param ruleCode 编码规则
   * @param number 生成数量
   * @param mixStrLen 自增部分位数，如果位数不够则在前面补零
   * @param expire 有效时间
   * @param unit 有效时间单位
   * @return 生成的编码集合
   */
  List<String> generateCode(String ruleCode, int number, Integer mixStrLen, long expire, TimeUnit unit);
}
