package com.biz.crm.business.common.sdk.utils;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * 时间日期格式校验
 *
 * @author ning.zhang
 * @date 2022/5/25
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class DateTimeValidateUtil {

  /**
   * 12:00:00
   */
  public static final String TIME_STR_120000 = "12:00:00";
  /**
   * 每天最早的时刻
   */
  public static final String TIME_STR_000000 = "00:00:00";
  /**
   * 每天最晚的时刻
   */
  public static final String TIME_STR_235959 = "23:59:59";
  /**
   * 时间日期格式 yyyy-MM-dd HH:mm:ss
   */
  public static final DateTimeFormatter YYYY_MM_DD_HH_MM_SS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM-dd
   */
  public static final DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
  /**
   * 时间日期格式 HH:mm:ss
   */
  public static final DateTimeFormatter HH_MM_SS = DateTimeFormatter.ofPattern("HH:mm:ss");
  /**
   * 时间日期格式 yyyy-MM
   */
  public static final DateTimeFormatter YYYY_MM = DateTimeFormatter.ofPattern("yyyy-MM");
  /**
   * 时间日期格式 yyyy
   */
  public static final DateTimeFormatter YYYY = DateTimeFormatter.ofPattern("yyyy");

  /**
   * 日期时间格式校验(yyyy-MM-dd HH:mm:ss)
   *
   * @param dateTime 日期时间字符串
   * @return 校验结果
   */
  public static Boolean validateDateTime(String dateTime) {
    Boolean result;
    try {
      LocalDateTime.parse(dateTime, YYYY_MM_DD_HH_MM_SS);
      result = Boolean.TRUE;
    } catch (Exception e) {
      result = Boolean.FALSE;
    }
    return result;
  }

  /**
   * 日期格式校验(yyyy-MM-dd)
   *
   * @param date 日期字符串
   * @return 校验结果
   */
  public static Boolean validateDate(String date) {
    Boolean result;
    try {
      LocalDate.parse(date, YYYY_MM_DD);
      result = Boolean.TRUE;
    } catch (Exception e) {
      result = Boolean.FALSE;
    }
    return result;
  }

  /**
   * 时间格式校验(HH:mm:ss)
   *
   * @param time 时间字符串
   * @return 校验结果
   */
  public static Boolean validateTime(String time) {
    Boolean result;
    try {
      LocalTime.parse(time, HH_MM_SS);
      result = Boolean.TRUE;
    } catch (Exception e) {
      result = Boolean.FALSE;
    }
    return result;
  }
}
