/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.config;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Base64Utils;

public class FeignClientConfiguration
implements RequestInterceptor {
    private static volatile Cache<String, String> cache = CacheBuilder.newBuilder().initialCapacity(10).expireAfterWrite(168L, TimeUnit.DAYS).maximumSize(100000L).build();
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    public void apply(RequestTemplate requestTemplate) {
        String traceId;
        boolean authedFlag;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean bl = authedFlag = authentication == null || authentication.getPrincipal() == null || StringUtils.equals((CharSequence)"anonymousUser", (CharSequence)authentication.getPrincipal().toString());
        if (authedFlag) {
            String tempJwt = this.getDefaultJwt();
            requestTemplate.header("jwt", new String[]{tempJwt});
        }
        if (StringUtils.isNotBlank((CharSequence)(traceId = MDC.get((String)"Trace_id")))) {
            requestTemplate.header("Trace_id", new String[]{traceId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDefaultJwt() {
        String tempJwt = (String)cache.getIfPresent((Object)TenantUtils.getTenantCode());
        if (tempJwt != null) return tempJwt;
        Class<FeignClientConfiguration> clazz = FeignClientConfiguration.class;
        synchronized (FeignClientConfiguration.class) {
            while (tempJwt == null) {
                AbstractCrmUserIdentity abstractCrmUserIdentity = new AbstractCrmUserIdentity(){

                    @Override
                    public String getPostCode() {
                        return null;
                    }

                    @Override
                    public String getPostName() {
                        return null;
                    }
                };
                abstractCrmUserIdentity.setLoginType(1);
                abstractCrmUserIdentity.setIdentityType("u");
                abstractCrmUserIdentity.setTenantCode(TenantUtils.getTenantCode());
                abstractCrmUserIdentity.setUsername(this.simpleSecurityProperties.getIndependencyUser());
                abstractCrmUserIdentity.setAccount(this.simpleSecurityProperties.getIndependencyUser());
                abstractCrmUserIdentity.setRealName("\u7cfb\u7edf\u7528\u6237\u6216\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1");
                abstractCrmUserIdentity.setRoleCodes(this.simpleSecurityProperties.getIndependencyRoles());
                tempJwt = FeignClientConfiguration.encode(abstractCrmUserIdentity, -1, this.simpleSecurityProperties.getSecretKey());
                cache.put((Object)TenantUtils.getTenantCode(), (Object)tempJwt);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tempJwt;
        }
    }

    public static boolean containsString(String[] array, String url) {
        if (array == null || array.length == 0 || StringUtils.isBlank((CharSequence)url)) {
            return true;
        }
        int i = url.indexOf("?");
        AtomicReference<String> urlRef = new AtomicReference<String>(i > 0 ? url.substring(0, i) : url);
        return Arrays.stream(array).anyMatch(str -> {
            if (str.indexOf("*") > 0) {
                str = str.replaceAll("\\*", "");
                return url.startsWith((String)str);
            }
            return StringUtils.equals((CharSequence)str, (CharSequence)((CharSequence)urlRef.get()));
        });
    }

    private static String encode(UserIdentity userIdentity, int ttl, String secretKey) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS512;
        Date now = new Date();
        HashMap jwsHeader = Maps.newHashMap();
        jwsHeader.put("alg", signatureAlgorithm.getValue());
        jwsHeader.put("kid", userIdentity.getAccount());
        jwsHeader.put("typ", userIdentity.getIdentityType());
        jwsHeader.put("ttl", ttl);
        jwsHeader.put("tenantCode", userIdentity.getTenantCode());
        JSONObject userJson = (JSONObject)JSONObject.toJSON((Object)userIdentity);
        Claims claims = Jwts.claims();
        claims.put((Object)"userinfo", (Object)userJson);
        Date expiration = null;
        expiration = ttl > 0 ? DateUtils.addMilliseconds((Date)now, (int)ttl) : (ttl == -1 ? DateUtils.addHours((Date)now, (int)87600) : DateUtils.addHours((Date)now, (int)168));
        String base64EncodedSecretKey = Base64Utils.encodeToString((byte[])secretKey.getBytes());
        JwtBuilder builder = Jwts.builder().compressWith(CompressionCodecs.GZIP).setHeader((Map)jwsHeader).setClaims(claims).setExpiration(expiration).signWith(signatureAlgorithm, base64EncodedSecretKey);
        return builder.compact();
    }
}

