/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.sdk.utils;

import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeUtil {
    public static List<TreeVo> generateTreeByParentCode(List<TreeVo> totalList) {
        ArrayList<TreeVo> treeList = new ArrayList<TreeVo>();
        ArrayList<TreeVo> curLevelList = new ArrayList<TreeVo>();
        ArrayList<TreeVo> restList = new ArrayList<TreeVo>();
        Map<String, TreeVo> totalMap = totalList.stream().collect(Collectors.toMap(TreeVo::getCode, v -> v));
        for (TreeVo item : totalList) {
            if (StringUtils.isEmpty((CharSequence)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<TreeVo> restTempList = new ArrayList<TreeVo>();
            ArrayList<TreeVo> curLevelTempList = new ArrayList<TreeVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(TreeVo::getCode, TreeVo::getCode, (v1, v2) -> v1));
            HashMap curLevelChildrenMap = new HashMap();
            for (TreeVo item : restList) {
                if (curLevelMap.containsKey(item.getParentCode())) {
                    curLevelTempList.add(item);
                    ArrayList<TreeVo> childrenList = new ArrayList<TreeVo>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(item.getParentCode()));
                    }
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(item);
            }
            for (TreeVo item : curLevelList) {
                if (!curLevelChildrenMap.containsKey(item.getCode())) continue;
                item.setChildren((List)curLevelChildrenMap.get(item.getCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    public static void excludeCodeAndChildren(List<TreeVo> tree, String excludeCodeAncChildren) {
        if (!CollectionUtils.isEmpty(tree) && StringUtils.isNotEmpty((CharSequence)excludeCodeAncChildren)) {
            Iterator<TreeVo> iterator = tree.iterator();
            while (iterator.hasNext()) {
                TreeVo item = iterator.next();
                if (item.getCode().equals(excludeCodeAncChildren)) {
                    iterator.remove();
                    return;
                }
                TreeUtil.excludeCodeAndChildren(item.getChildren(), excludeCodeAncChildren);
            }
        }
    }

    public static List<LazyTreeVo> generateLazyTreeByParentCode(List<LazyTreeVo> totalList) {
        ArrayList<LazyTreeVo> treeList = new ArrayList<LazyTreeVo>();
        ArrayList<LazyTreeVo> curLevelList = new ArrayList<LazyTreeVo>();
        ArrayList<LazyTreeVo> restList = new ArrayList<LazyTreeVo>();
        Map<String, LazyTreeVo> totalMap = totalList.stream().collect(Collectors.toMap(LazyTreeVo::getCode, v -> v));
        for (LazyTreeVo item : totalList) {
            if (!StringUtils.isNotEmpty((CharSequence)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<LazyTreeVo> restTempList = new ArrayList<LazyTreeVo>();
            ArrayList<LazyTreeVo> curLevelTempList = new ArrayList<LazyTreeVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(LazyTreeVo::getCode, LazyTreeVo::getCode, (v1, v2) -> v1));
            HashMap curLevelChildrenMap = new HashMap();
            for (LazyTreeVo item : restList) {
                if (curLevelMap.containsKey(item.getParentCode())) {
                    curLevelTempList.add(item);
                    ArrayList<LazyTreeVo> childrenList = new ArrayList<LazyTreeVo>();
                    if (curLevelChildrenMap.containsKey(item.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(item.getParentCode()));
                    }
                    childrenList.add(item);
                    curLevelChildrenMap.put(item.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(item);
            }
            for (LazyTreeVo item : curLevelList) {
                if (!curLevelChildrenMap.containsKey(item.getCode())) continue;
                item.setChildren((List)curLevelChildrenMap.get(item.getCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

