/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.interceptor;

import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.beans.factory.annotation.Autowired;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class DefaultMybatisBaseFieldInterceptor
implements Interceptor {
    @Autowired
    private LoginUserService loginUserService;

    public Object intercept(Invocation invocation) throws Throwable {
        UuidEntity entity;
        Map map;
        Object parameter = invocation.getArgs()[1];
        MappedStatement statement = (MappedStatement)invocation.getArgs()[0];
        if (parameter instanceof MapperMethod.ParamMap && (map = (Map)parameter).containsKey("et") && Objects.nonNull(map.get("et"))) {
            parameter = ((Map)parameter).get("et");
        }
        if (parameter instanceof UuidOpEntity) {
            entity = (UuidOpEntity)parameter;
            AbstractCrmUserIdentity context = this.loginUserService.getAbstractLoginUser();
            String account = context != null ? context.getAccount() : "admin";
            String username = context != null ? context.getRealName() : "\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u7cfb\u7edf\u5b9a\u65f6\u4efb\u52a1";
            switch (statement.getSqlCommandType()) {
                case INSERT: {
                    if (Objects.isNull(((UuidOpEntity)entity).getCreateTime())) {
                        ((UuidOpEntity)entity).setCreateTime(new Date());
                    }
                    if (StringUtils.isBlank((CharSequence)((UuidOpEntity)entity).getCreateAccount())) {
                        ((UuidOpEntity)entity).setCreateAccount(account);
                    }
                    if (StringUtils.isBlank((CharSequence)((UuidOpEntity)entity).getCreateName())) {
                        ((UuidOpEntity)entity).setCreateName(username);
                    }
                    if (Objects.isNull(((UuidOpEntity)entity).getModifyTime())) {
                        ((UuidOpEntity)entity).setModifyTime(new Date());
                    }
                    if (StringUtils.isBlank((CharSequence)((UuidOpEntity)entity).getModifyAccount())) {
                        ((UuidOpEntity)entity).setModifyAccount(account);
                    }
                    if (!StringUtils.isBlank((CharSequence)((UuidOpEntity)entity).getModifyName())) break;
                    ((UuidOpEntity)entity).setModifyName(username);
                    break;
                }
                case UPDATE: {
                    if (Objects.isNull(((UuidOpEntity)entity).getModifyTime())) {
                        ((UuidOpEntity)entity).setModifyTime(new Date());
                    }
                    if (StringUtils.isBlank((CharSequence)((UuidOpEntity)entity).getModifyAccount())) {
                        ((UuidOpEntity)entity).setModifyAccount(account);
                    }
                    if (!StringUtils.isBlank((CharSequence)((UuidOpEntity)entity).getModifyName())) break;
                    ((UuidOpEntity)entity).setModifyName(username);
                    break;
                }
            }
        }
        if (parameter instanceof UuidFlagOpEntity) {
            entity = (UuidFlagOpEntity)parameter;
            if (SqlCommandType.INSERT.equals((Object)statement.getSqlCommandType())) {
                if (Objects.isNull(((UuidFlagOpEntity)entity).getDelFlag())) {
                    ((UuidFlagOpEntity)entity).setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                }
                if (Objects.isNull(((UuidFlagOpEntity)entity).getEnableStatus())) {
                    ((UuidFlagOpEntity)entity).setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                }
            }
        }
        if (parameter instanceof TenantOpEntity) {
            entity = (TenantOpEntity)parameter;
            if (SqlCommandType.INSERT.equals((Object)statement.getSqlCommandType()) && Objects.isNull(((TenantOpEntity)entity).getTenantCode())) {
                ((TenantOpEntity)entity).setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (parameter instanceof TenantFlagOpEntity) {
            entity = (TenantFlagOpEntity)parameter;
            if (SqlCommandType.INSERT.equals((Object)statement.getSqlCommandType()) && Objects.isNull(((TenantFlagOpEntity)entity).getTenantCode())) {
                ((TenantFlagOpEntity)entity).setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (parameter instanceof TenantEntity) {
            entity = (TenantEntity)parameter;
            if (SqlCommandType.INSERT.equals((Object)statement.getSqlCommandType()) && Objects.isNull(((TenantEntity)entity).getTenantCode())) {
                ((TenantEntity)entity).setTenantCode(TenantUtils.getTenantCode());
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

