/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.business.common.local.service.internal;

import com.biz.crm.business.common.sdk.service.RedisService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
implements RedisService {
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public void set(String key, Object value, long time) {
        this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
    }

    @Override
    public void set(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    @Override
    public void setRPushAll(String key, List<?> value, long timeout, TimeUnit unit) {
        List objValue = value.stream().map(Object::toString).collect(Collectors.toList());
        this.redisTemplate.opsForList().rightPushAll((Object)key, objValue.toArray());
        this.redisTemplate.expire((Object)key, timeout, unit);
    }

    @Override
    public Object get(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public Object getRightPop(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)key);
    }

    @Override
    public Boolean del(String key) {
        return this.redisTemplate.delete((Object)key);
    }

    @Override
    public Long del(List<String> keys) {
        return this.redisTemplate.delete(keys);
    }

    @Override
    public Boolean expire(String key, long time) {
        return this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
    }

    @Override
    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    @Override
    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    @Override
    public Long incr(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    @Override
    public Long decr(String key, long delta) {
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    @Override
    public Object hGet(String key, String hashKey) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
    }

    @Override
    public Boolean hSet(String key, String hashKey, Object value, long time) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
        return this.expire(key, time);
    }

    @Override
    public void hSet(String key, String hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    @Override
    public Map<Object, Object> hGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    @Override
    public Boolean hSetAll(String key, Map<String, Object> map, long time) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
        return this.expire(key, time);
    }

    @Override
    public void hSetAll(String key, Map<String, ?> map) {
        this.redisTemplate.opsForHash().putAll((Object)key, map);
    }

    @Override
    public void hDel(String key, Object ... hashKey) {
        this.redisTemplate.opsForHash().delete((Object)key, hashKey);
    }

    @Override
    public Boolean hHasKey(String key, String hashKey) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashKey);
    }

    @Override
    public Long hIncr(String key, String hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, delta.longValue());
    }

    @Override
    public Long hDecr(String key, String hashKey, Long delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)hashKey, -delta.longValue());
    }

    @Override
    public Set<Object> sMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public Long sAdd(String key, Object ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, values);
    }

    @Override
    public Long sAdd(String key, long time, Object ... values) {
        Long count = this.redisTemplate.opsForSet().add((Object)key, values);
        this.expire(key, time);
        return count;
    }

    @Override
    public Boolean sIsMember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    @Override
    public Long sSize(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    @Override
    public Long sRemove(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    @Override
    public List<Object> lRange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    @Override
    public Long lSize(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    @Override
    public Object lIndex(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    @Override
    public Long lPush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    @Override
    public Long lPush(String key, Object value, long time) {
        Long index = this.redisTemplate.opsForList().rightPush((Object)key, value);
        this.expire(key, time);
        return index;
    }

    @Override
    public Long lPushAll(String key, Object ... values) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, values);
    }

    @Override
    public Long lPushAll(String key, Long time, Object ... values) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, values);
        this.expire(key, time);
        return count;
    }

    @Override
    public Long lRemove(String key, long count, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, count, value);
    }

    @Override
    public Boolean bitAdd(String key, int offset, boolean b) {
        return this.redisTemplate.opsForValue().setBit((Object)key, (long)offset, b);
    }

    @Override
    public Boolean bitGet(String key, int offset) {
        return this.redisTemplate.opsForValue().getBit((Object)key, (long)offset);
    }

    @Override
    public Long bitCount(String key) {
        return (Long)this.redisTemplate.execute(con -> con.bitCount(key.getBytes()));
    }

    @Override
    public List<Long> bitField(String key, int limit, int offset) {
        return (List)this.redisTemplate.execute(con -> con.bitField(key.getBytes(), BitFieldSubCommands.create().get(BitFieldSubCommands.BitFieldType.unsigned((int)limit)).valueAt((long)offset)));
    }

    @Override
    public byte[] bitGetAll(String key) {
        return (byte[])this.redisTemplate.execute(con -> con.get(key.getBytes()));
    }

    @Override
    public Long geoAdd(String key, Double x, Double y, String name) {
        return this.redisTemplate.opsForGeo().add((Object)key, new Point(x.doubleValue(), y.doubleValue()), (Object)name);
    }

    @Override
    public List<Point> geoGetPointList(String key, Object ... place) {
        return this.redisTemplate.opsForGeo().position((Object)key, place);
    }

    @Override
    public Distance geoCalculationDistance(String key, String placeOne, String placeTow) {
        return this.redisTemplate.opsForGeo().distance((Object)key, (Object)placeOne, (Object)placeTow, (Metric)RedisGeoCommands.DistanceUnit.KILOMETERS);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<Object>> geoNearByPlace(String key, String place, Distance distance, long limit, Sort.Direction sort) {
        RedisGeoCommands.GeoRadiusCommandArgs args = RedisGeoCommands.GeoRadiusCommandArgs.newGeoRadiusArgs().includeDistance().includeCoordinates();
        if (Sort.Direction.ASC == sort) {
            args.sortAscending();
        } else {
            args.sortDescending();
        }
        args.limit(limit);
        return this.redisTemplate.opsForGeo().radius((Object)key, (Object)place, distance, args);
    }

    @Override
    public List<String> geoGetHash(String key, String ... place) {
        GeoOperations geoOperations = this.redisTemplate.opsForGeo();
        List hash = geoOperations.hash((Object)key, (Object[])place);
        return hash;
    }
}

