package com.biz.crm.common.personalized.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.service.PersonalizedFavoritesService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:38
 * @description：个性化功能收藏夹
 */
@Slf4j
@RestController
@RequestMapping("/v1/personalizedFavorites/personalizedFavorites")
@Api(tags = "个性化功能收藏夹 : PersonalizedFavorites : 个性化功能收藏夹")
public class PersonalizedFavoritesController {

  @Autowired(required = false)
  private PersonalizedFavoritesService personalizedFavoritesService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<PersonalizedFavorites>> findByConditions(
          @PageableDefault(50) Pageable pageable, PersonalizedFavorites paginationDto) {
    try {
      paginationDto = Optional.ofNullable(paginationDto).orElse(new PersonalizedFavorites());
      Page<PersonalizedFavorites> result = this.personalizedFavoritesService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建及排序
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "创建及排序")
  @PostMapping(value = "")
  public Result<List<PersonalizedFavorites>> create(@RequestBody PersonalizedFavoritesDto dto) {
    try {
      List<PersonalizedFavorites> current = this.personalizedFavoritesService.create(dto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "物理删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      this.personalizedFavoritesService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
