package com.biz.crm.common.personalized.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.personalized.local.entity.PersonalizedTheme;
import com.biz.crm.common.personalized.local.service.PersonalizedThemeService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedThemePaginationDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

/**
 * personalized_theme 个性化主题表控制层
 *
 * @author hejun
 * @date 2023/2/13 14:29
 * @description 个性化主题模块api
 */

@Slf4j
@RestController
@RequestMapping("/v1/personalizedTheme/personalizedTheme")
@Api(tags = "个性化主题 : PersonalizedTheme : 个性化主题")
public class PersonalizedThemeController {
  @Autowired(required = false)
  private PersonalizedThemeService personalizedThemeService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<PersonalizedTheme>> findByConditions(
      @PageableDefault(50) Pageable pageable, PersonalizedThemePaginationDto paginationDto) {
    try {
      paginationDto = Optional.ofNullable(paginationDto).orElse(new PersonalizedThemePaginationDto());
      paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      Page<PersonalizedTheme> result = this.personalizedThemeService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      this.personalizedThemeService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      this.personalizedThemeService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value="详情")
  @RequestMapping("/findDetailById")
  public Result<PersonalizedTheme> findDetailById(@RequestParam("id") String id){
    List<String> ids = Lists.newLinkedList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    try {
      PersonalizedTheme personalizedTheme  = personalizedThemeService.findDetailById(id);
      return Result.ok(personalizedTheme);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param personalizedTheme
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<PersonalizedTheme> create(@RequestBody PersonalizedTheme personalizedTheme) {
    try {
      PersonalizedTheme current = this.personalizedThemeService.create(personalizedTheme);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param personalizedTheme
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<PersonalizedTheme> update(@RequestBody PersonalizedTheme personalizedTheme) {
    try {
      PersonalizedTheme current = this.personalizedThemeService.update(personalizedTheme);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      this.personalizedThemeService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
