package com.biz.crm.common.personalized.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:23
 * @description：功能收藏夹
 */
@Data
@Entity
@TableName("personalized_favorites")
@ApiModel(value = "PersonalizedFavorites", description = "功能收藏夹")
@Table(name = "personalized_favorites",  indexes = {
        @Index(name = "personalized_favorites_index1", columnList = "tenant_code,del_flag,current_account,favorites_sort")
})
public class PersonalizedFavorites extends TenantFlagOpEntity implements Serializable {

  /**
   * 当前用户
   */
  @ApiModelProperty("当前用户")
  @TableField(value = "current_account")
  @Column(name = "current_account", length = 64, columnDefinition = "varchar(64) COMMENT '当前用户'")
  private String currentAccount;

  @ApiModelProperty("菜单编码")
  @TableField(value = "competence_code")
  @Column(name = "competence_code",length = 64 ,columnDefinition = "varchar(64) COMMENT '菜单编码'")
  private String competenceCode;


  @ApiModelProperty("菜单排序")
  @TableField(value = "competence_sort")
  @Column(name = "competence_sort", nullable = false, columnDefinition = "smallint COMMENT '菜单排序'")
  private Integer competenceSort;

}
