package com.biz.crm.common.personalized.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.Table;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.io.Serializable;

/**
 * @author hejun
 * @title PersonalizedTheme
 * @date 2023/2/13 13:59
 * @description 个性化主题
 */
@Data
@Entity
@Table(appliesTo = "personalized_theme",comment = "个性化主题")
@TableName("personalized_theme")
@ApiModel(value = "PersonalizedTheme",description = "个性化主题")
public class PersonalizedTheme extends TenantFlagOpEntity {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty("系统主题编码")
  @TableField(value = "theme_code")
  @Column(name = "theme_code",length = 64 ,columnDefinition = "varchar(64) COMMENT '系统主题编码'")
  private String themeCode;

  @ApiModelProperty("系统主题名称")
  @TableField(value = "theme_name")
  @Column(name = "theme_name",length = 64 ,columnDefinition = "varchar(64) COMMENT '系统主题名称'")
  private String themeName;

  @ApiModelProperty("系统主题内容")
  @TableField(value = "theme_url")
  @Column(name = "theme_url",columnDefinition = "TEXT COMMENT '系统主题内容'")
  private String themeUrl;

  @ApiModelProperty("用户名称")
  @TableField(value = "user_name")
  @Column(name = "user_name",length = 64 ,columnDefinition = "varchar(64) COMMENT '用户名称'")
  private String userName;


}
