package com.biz.crm.common.personalized.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.personalized.local.entity.PersonalizedTheme;
import com.biz.crm.common.personalized.local.mapper.PersonalizedThemeMapper;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedThemePaginationDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author hejun
 * @date 2023/2/13 14:55
 * @description 个性化主题表（repository）
 */
@Component
public class PersonalizedThemeRepository extends ServiceImpl<PersonalizedThemeMapper, PersonalizedTheme> {

  /**
   * 分页查询
   * @param page
   * @param paginationDto
   * @return
   */
  public Page<PersonalizedTheme> findByConditions(Page<PersonalizedTheme> page, PersonalizedThemePaginationDto paginationDto) {
    return baseMapper.findByConditions(page,paginationDto);
  }

  /**
   * 根据id集合批量修改启用状态
   * @param ids  id集合
   * @param enable 状态
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .eq(PersonalizedTheme::getTenantCode,TenantUtils.getTenantCode())
        .in(PersonalizedTheme::getId,ids)
        .set(PersonalizedTheme::getEnableStatus,enable.getCode())
        .update();
  }

  /**
   * 根据主题编码计数
   * (同一租户下主题编码唯一)
   * @return
   * @param themeCode
   */
  public Integer CountByThemeCode(String themeCode) {
   return this.lambdaQuery()
        .eq(PersonalizedTheme::getThemeCode,themeCode)
        .eq(PersonalizedTheme::getTenantCode,TenantUtils.getTenantCode())
        .count();
  }

  /**
   * 根据id和租户编号查询主题数据
   * @param id
   * @param tenantCode
   * @return
   */
  public PersonalizedTheme findById(String id, String tenantCode) {
    return this.lambdaQuery()
        .eq(PersonalizedTheme::getTenantCode,tenantCode)
        .in(PersonalizedTheme::getId,id)
        .one();
  }

  /**
   * 逻辑删除
   * @param ids
   */
  public void updateBatchByIds(List<String> ids) {
    this.lambdaUpdate()
        .eq(PersonalizedTheme::getTenantCode,TenantUtils.getTenantCode())
        .in(PersonalizedTheme::getId,ids)
        .set(PersonalizedTheme::getDelFlag, DelFlagStatusEnum.DELETE)
        .update();
  }

  /**
   * 根据id集合批量查询
   * @param ids
   */
  public List<PersonalizedTheme> findThemesByIds(List<String> ids) {
   return this.lambdaQuery()
        .eq(PersonalizedTheme::getTenantCode,TenantUtils.getTenantCode())
        .in(PersonalizedTheme::getId,ids)
        .list();
  }
}
