package com.biz.crm.common.personalized.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:40
 * @description：个性化功能收藏夹service
 */
public interface PersonalizedFavoritesService {

  /**
   * 分页查询
   * @param pageable
   * @param personalizedFavorites
   * @return
   */
  Page<PersonalizedFavorites> findByConditions(Pageable pageable, PersonalizedFavorites personalizedFavorites);

  /**
   * 新增
   * @param personalizedFavorites
   * @return
   */
  List<PersonalizedFavorites> create(PersonalizedFavoritesDto dto);

  /**
   * 逻辑删除
   * @param ids
   */
  void deleteBatch(List<String> ids);



}
