package com.biz.crm.common.personalized.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.personalized.local.entity.PersonalizedTheme;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedThemePaginationDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author hejun
 * @title PersonalizedThemeService
 * @date 2023/2/13 14:46
 * @description
 */
public interface PersonalizedThemeService {
  /**
   * 分页查询
   * @param pageable
   * @param paginationDto
   * @return
   */
  Page<PersonalizedTheme> findByConditions(Pageable pageable, PersonalizedThemePaginationDto paginationDto);

  /**
   * 根据id集合批量启用
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 根据id集合批量禁用
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 新增
   * @param personalizedTheme
   * @return
   */
  PersonalizedTheme create(PersonalizedTheme personalizedTheme);

  /**
   * 修改
   * @param personalizedTheme
   * @return
   */
  PersonalizedTheme update(PersonalizedTheme personalizedTheme);

  /**
   * 详情
   * @param id
   * @return
   */
  PersonalizedTheme findDetailById(String id);

  /**
   * 逻辑删除
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);
}
