package com.biz.crm.common.personalized.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.personalized.local.entity.PersonalizedFavorites;
import com.biz.crm.common.personalized.local.repository.PersonalizedFavoritesRepository;
import com.biz.crm.common.personalized.local.service.PersonalizedFavoritesService;
import com.biz.crm.common.personalized.sdk.dto.PersonalizedFavoritesDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * @author XXLsansui
 * @date 2023-02-14 16:40
 * @description：个性化功能收藏夹服务实现类
 */
@Service("personalizedFavoritesService")
public class PersonalizedFavoritesServiceImpl implements PersonalizedFavoritesService {

  @Autowired(required = false)
  private PersonalizedFavoritesRepository personalizedFavoritesRepository;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 分页查询
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @Override
  public Page<PersonalizedFavorites> findByConditions(Pageable pageable, PersonalizedFavorites paginationDto) {
    //根据 租户 del_flag 当前用户 排序字段 查询列表
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0,50));
    paginationDto = Optional.ofNullable(paginationDto).orElse(new PersonalizedFavorites());
    paginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    paginationDto.setTenantCode(TenantUtils.getTenantCode());
    paginationDto.setCurrentAccount(loginUserService.getLoginAccountName());
    Page<PersonalizedFavorites>page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<PersonalizedFavorites>pageResult = this.personalizedFavoritesRepository.findByConditions(page,paginationDto);
    if (CollectionUtils.isEmpty(pageResult.getRecords())){
      return null;
    }
    return pageResult;
  }

  /**
   * 新增
   *
   * @param dto
   * @return
   */
  @Override
  @Transactional
  public List<PersonalizedFavorites> create(PersonalizedFavoritesDto dto) {
    Validate.notNull(dto, "收藏菜单信息缺失");
    Validate.isTrue(ObjectUtils.isNotEmpty(dto.getCompetenceCodes()), "收藏菜单编码不能为空");
    //菜单编码为1个的时候为追加 为多个的时候为排序
    String tenantCode = TenantUtils.getTenantCode();
    //当前登陆人
    String currentAccount = loginUserService.getLoginAccountName();
    List<PersonalizedFavorites> list = new ArrayList<>();
    if(dto.getCompetenceCodes().size() == 1){
      PersonalizedFavorites one = new PersonalizedFavorites();
      list.add(one);
      //补充原有数据
      List<PersonalizedFavorites> oldList = this.personalizedFavoritesRepository.lambdaQuery()
              .eq(PersonalizedFavorites::getTenantCode, tenantCode)
              .eq(PersonalizedFavorites::getCurrentAccount, currentAccount)
              .eq(PersonalizedFavorites::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
              .orderByAsc(PersonalizedFavorites::getCompetenceSort)
              .list();
      list.addAll(oldList);
    }else {
      dto.getCompetenceCodes().forEach(k -> {
        PersonalizedFavorites one = new PersonalizedFavorites();
        one.setCompetenceCode(k);
        list.add(one);
      });
    }
    //补充其他基本信息及排序
    for (int i = 0; i < list.size(); i++) {
      PersonalizedFavorites one = list.get(i);
      one.setCompetenceSort(i);
      one.setTenantCode(tenantCode);
      one.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
      one.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      one.setCurrentAccount(currentAccount);
      one.setCreateName(currentAccount);
      one.setCreateTime(new Date());
    }
    //先删除旧的 再保存新的
    LambdaQueryWrapper<PersonalizedFavorites> lambdaQueryWrapper = Wrappers.lambdaQuery();
    lambdaQueryWrapper
            .eq(PersonalizedFavorites::getTenantCode, tenantCode)
            .eq(PersonalizedFavorites::getCurrentAccount, currentAccount);
    personalizedFavoritesRepository.remove(lambdaQueryWrapper);
    personalizedFavoritesRepository.saveBatch(list);
    //返回最终数据
    return list;
  }

  /**
   * 物理删除
   *
   * @param ids
   */
  @Override
  public void deleteBatch(List<String> ids) {
    Validate.isTrue(!org.springframework.util.CollectionUtils.isEmpty(ids), "待修正的数据主键不能为空");
    personalizedFavoritesRepository.removeByIds(ids);
  }



}
