package com.biz.crm.dms.admin.web;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import org.springframework.data.elasticsearch.repository.config.EnableElasticsearchRepositories;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@MapperScan(value={"com.biz.crm.**.mapper*"})
@EnableFeignClients(basePackages = "com.biz.crm.*")
@SpringBootApplication(scanBasePackages = {"com.biz.crm.mdm.*","com.biz.crm.dms.*", "com.biz.crm.common.*","com.bizunited.nebula.*"})
@EnableTransactionManagement
@EnableSwagger2
@Slf4j
@EnableDiscoveryClient
@EnableElasticsearchRepositories(basePackages = "com.biz.crm.common.log.local.repository")
public class ApplicationBootstrap {
  public static void main(String[] args) {
    System.setProperty("es.set.netty.runtime.available.processors", "false");
    ConfigurableApplicationContext application = new SpringApplicationBuilder(ApplicationBootstrap.class).bannerMode(Banner.Mode.OFF).web(WebApplicationType.SERVLET).run(args);
    Environment env = application.getEnvironment();
    String port = env.getProperty("server.port");
    String path = env.getProperty("server.servlet.context-path");
    log.info("\n----------------------------------------------------------\n\t" +
            "Application crm-dms is running! Access URLs:\n\t" +
            "本地访问地址: \t\thttp://localhost:" + port + path + "/\n\t" +
            "swagger地址: \t\thttp://localhost:" + port + path + "/doc.html\n" +
            "----------------------------------------------------------");
  }
}
