package com.biz.crm.dms.admin.web.exports.stockcustomer.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月29日 15:51:00
 */
@ApiModel(value = "StockStatistics", description = "库存提报拓展主表")
@Getter
@Setter
@CrmExcelExport
public class StockStatisticsExtendExportsVo extends CrmExcelVo {
  /**
   * 客户所属组织名称
   */
  @ApiModelProperty(name = "cusOrgName", notes = "客户所属组织名称", value = "客户所属组织名称")
  private String cusOrgName;
  /**
   * 客户编码
   */
  @CrmExcelColumn("客户编码")
  @ApiModelProperty(name = "cusCode", notes = "客户编码", value = "客户编码")
  private String cusCode;
  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  @ApiModelProperty(name = "cusName", notes = "客户名称", value = "客户名称")
  private String cusName;
  /**
   * 客户所属组织编码
   */
  @ApiModelProperty(name = "cusOrgCode", notes = "客户所属组织编码", value = "客户所属组织编码")
  private String cusOrgCode;
  /**
   * 商品编码
   */
  @CrmExcelColumn("商品编码")
  @ApiModelProperty(name = "productCode", notes = "商品编码", value = "商品编码")
  private String productCode;
  /**
   * 商品名称
   */
  @CrmExcelColumn("商品名称")
  @ApiModelProperty(name = "productName", notes = "商品名称", value = "商品名称")
  private String productName;
  /**
   * 商品单位
   */
  @CrmExcelColumn("商品单位")
  @ApiModelProperty(name = "productUnit", notes = "商品单位", value = "商品单位")
  private String productUnit;
  /**
   * 库存时间
   */
  @CrmExcelColumn("库存时间")
  @ApiModelProperty(name = "stockTime", notes = "库存时间", value = "库存时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private String stockTime;
  /**
   * 提报前最新库存量
   */
  @CrmExcelColumn("提报前最新库存量")
  @ApiModelProperty(name = "stockQuantity", notes = "库存量", value = "库存量")
  private Double stockQuantity;
  /**
   * 库存量
   */
  @CrmExcelColumn("库存量")
  @ApiModelProperty(name = "operationQuantity", notes = "库存量", value = "库存量")
  private Double operationQuantity;
  /**
   * 备注
   */
  @CrmExcelColumn("备注")
  @ApiModelProperty(name = "remark", notes = "备注", value = "备注")
  private String remark;
}
