package com.biz.crm.dms.admin.web.exports.stockcustomer.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.dms.admin.web.exports.stockcustomer.model.StockStatisticsExportsDto;
import com.biz.crm.dms.admin.web.exports.stockcustomer.model.StockStatisticsExportsVo;
import com.biz.crm.dms.business.stock.customer.local.entity.StockStatistics;
import com.biz.crm.dms.business.stock.customer.local.service.StockStatisticsService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * 库存提报主表;(dms_stock_statistics)导出服务接口
 *
 * @author : Keller
 * @date : 2022-7-29
 */
@Component
public class StockStatisticsExportsProcess implements ExportProcess<StockStatisticsExportsVo> {
  @Autowired
  private StockStatisticsService stockStatisticsService;
  @Autowired
  private DictDataVoService dictDataVoService;

  /**
   * 获取总条数
   *
   * @param params
   * @return
   */
  @Override
  public Integer getTotal(Map<String, Object> params) {
    StockStatisticsExportsDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(1, 1);
    long total = this.stockStatisticsService.findByConditions(pageable, dto).getTotal();
    return Long.valueOf(total).intValue();
  }

  @Override
  public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
    StockStatisticsExportsDto dto = this.convertParams(params);
    Pageable pageable = PageRequest.of(vo.getPageNo(), vo.getPageSize());
    Page<StockStatistics> byConditions = this.stockStatisticsService.findByConditions(pageable, dto);
    return JSON.parseArray(JSON.toJSONString(byConditions.getRecords()));
  }

  /**
   * 获取对象转换实体
   *
   * @return
   */
  @Override
  public Class<StockStatisticsExportsVo> findCrmExcelVoClass() {
    return StockStatisticsExportsVo.class;
  }

  /**
   * 模板编码
   *
   * @return
   */
  @Override
  public String getBusinessCode() {
    return "DMS_STOCK_STATISTICS_EXPORT";
  }

  /**
   * 模板名称
   *
   * @return
   */
  @Override
  public String getBusinessName() {
    return "库存提报主表导出";
  }

  /**
   * 获取参数
   *
   * @param params
   * @return
   */
  private StockStatisticsExportsDto convertParams(Map<String, Object> params) {
    // map 参数转换为对应的dto参数对象，可以手工进行修改设置
    StockStatisticsExportsDto dto = JSON.parseObject(JSON.toJSONString(params), StockStatisticsExportsDto.class);
    return dto;
  }

  /**
   * 调整数据
   *
   * @param data
   */
  private void adjustData(List<StockStatisticsExportsVo> data) {
    if (CollectionUtils.isEmpty(data)) {
      return;
    }
  }

  /**
   * 获取字典值
   *
   * @param mapDict
   * @param dictTypeCode
   * @param code
   * @return
   */
  private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
    if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
      return StringUtils.EMPTY;
    }
    final List<DictDataVo> vos = mapDict.get(dictTypeCode);
    if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
      return StringUtils.EMPTY;
    }
    final Optional<String> first =
        vos.stream()
            .filter(a -> a.getDictCode().equals(code))
            .map(DictDataVo::getDictValue)
            .findFirst();
    return first.orElse(StringUtils.EMPTY);
  }
}