package com.biz.crm.dms.admin.web.imports.stockcustomer.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author HanJiaJun
 * @describe: 库存提库导入
 * @createTime 2022年07月29日 16:25:00
 */
@Data
@CrmExcelImport
public class StockStatisticsImportVo extends CrmExcelVo {
  /**
   * 客户编码
   */
  @CrmExcelColumn("客户编码")
  @ApiModelProperty(name = "cusCode", notes = "客户编码", value = "客户编码")
  private String cusCode;
  /**
   * 客户名称
   */
  @CrmExcelColumn("客户名称")
  @ApiModelProperty(name = "cusName", notes = "客户名称", value = "客户名称")
  private String cusName;
  /**
   * 商品编码
   */
  @CrmExcelColumn("商品编码")
  @ApiModelProperty(name = "productCode", notes = "商品编码", value = "商品编码")
  private String productCode;
  /**
   * 商品名称
   */
  @CrmExcelColumn("商品名称")
  @ApiModelProperty(name = "productName", notes = "商品名称", value = "商品名称")
  private String productName;
  /**
   * 商品单位
   */
  @CrmExcelColumn("商品单位")
  @ApiModelProperty(name = "productUnit", notes = "商品单位", value = "商品单位")
  private String productUnit;
  /**
   * 库存量
   */
  @CrmExcelColumn("库存量")
  @ApiModelProperty(name = "operationQuantity", notes = "库存量", value = "库存量")
  private Double operationQuantity;
  /**
   * 备注
   */
  @CrmExcelColumn("备注")
  @ApiModelProperty(name = "remark", notes = "备注", value = "备注")
  private String remark;
}
