package com.biz.crm.dms.admin.web.report.contract.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.contract.dto.ContractProductSkuPageDto;
import com.biz.crm.dms.admin.web.report.contract.service.ContractProductSkuVoService;
import com.biz.crm.dms.admin.web.report.contract.vo.ContractProductSkuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 合同产品sku
 *
 * @author hefan
 * @date 2022/09/13
 */
@RestController
@RequestMapping("/v1/report/contractProduct")
@Slf4j
@Api(tags = "商城报表：ContractProductSkuVo：合同商品")
public class ContractProductSkuVoController {

  @Autowired(required = false)
  private ContractProductSkuVoService contractProductSkuVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param contractProductSkuPageDto 合同商品分页Dto
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<ContractProductSkuVo>> findByConditions(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "contractProductSkuPageDto", value = "合同商品分页Dto") ContractProductSkuPageDto contractProductSkuPageDto) {
    try {
      Page<ContractProductSkuVo> page = this.contractProductSkuVoService.findByConditions(pageable, contractProductSkuPageDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
