package com.biz.crm.dms.admin.web.report.mall.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.mall.service.MallOrderVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.MallOrderVo;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商城订单vo控制器
 *
 * @author hefan
 * @date 2022/05/14
 */
@RestController
@RequestMapping("/v1/report/mallOrder")
@Slf4j
@Api(tags = "商城报表：MallOrderVo：含有sku图片")
public class MallOrderVoController {

  @Autowired(required = false)
  private MallOrderVoService mallOrderVoService;

  /**
   * 分页查询当前客户的数据
   *
   * @param pageable             分页对象
   * @param customerOrderPageDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询当前客户的数据", notes = "分页参数为page和size，page从1开始，size默认50;")
  @GetMapping("findByCustomerOrderPageDto")
  public Result<Page<MallOrderVo>> findByCustomerOrderPageDto(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "order", value = "订单主信息") CustomerOrderPageDto customerOrderPageDto) {
    try {
      Page<MallOrderVo> page = this.mallOrderVoService.findByCustomerOrderPageDto(pageable, customerOrderPageDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<MallOrderVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      MallOrderVo order = this.mallOrderVoService.findById(id);
      return Result.ok(order);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }




}
