package com.biz.crm.dms.admin.web.report.mall.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.mall.service.ProductWithMiniAndStockVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.ProductWithMiniAndStockVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 首页商品
 *
 * @author hefan
 * @date 2022/04/20
 */
@RestController
@RequestMapping("/v1/report/productWithMiniAndStock")
@Slf4j
@Api(tags = "商城报表：ProductWithMiniAndStockVo：具有最小起订量和库存的商品")
public class ProductWithMiniAndStockVoController {

  @Autowired(required = false)
  private ProductWithMiniAndStockVoService productWithMiniAndStockVoService;

  /**
   * 根据spuCode查询
   *
   * @param spuCode spu代码
   * @return 所有数据
   */
  @ApiOperation(value = "根据spuCode查询")
  @GetMapping("findBySpuCode")
  public Result<ProductWithMiniAndStockVo> findBySpuCode(@ApiParam(name = "spuCode", value = "商品spu编码") @RequestParam String spuCode) {
    try {
      //true代表在查询可购清单时进行模糊搜索 false代表在查询可够清单时不进行模糊搜索
      ProductWithMiniAndStockVo vo = this.productWithMiniAndStockVoService.findBySpuCode(spuCode, true);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据spuCode查询（含促销政策）
   *
   * @param spuCode spu代码
   * @return 所有数据
   */
  @ApiOperation(value = "根据spuCode查询（含促销政策）")
  @GetMapping("findJoinPolicyBySpuCode")
  public Result<ProductWithMiniAndStockVo> findJoinPolicyBySpuCode(@ApiParam(name = "spuCode", value = "商品spu编码") @RequestParam String spuCode) {
    try {
      ProductWithMiniAndStockVo vo = this.productWithMiniAndStockVoService.findJoinPolicyBySpuCode(spuCode);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


}
