package com.biz.crm.dms.admin.web.report.mall.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.admin.web.report.mall.vo.MallOrderVo;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import org.springframework.data.domain.Pageable;

/**
 * 商城订单vo服务
 *
 * @author hefan
 * @date 2022/05/14
 */
public interface MallOrderVoService {

  /**
   * 分页查询当前客户的数据
   *
   * @param pageable             可分页
   * @param customerOrderPageDto 客户订单页面dto
   * @return {@link Page}<{@link MallOrderVoService}>
   */
  Page<MallOrderVo> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto);

  /**
   * 发现通过id
   *
   * @param id id
   * @return {@link MallOrderVo}
   */
  MallOrderVo findById(String id);
}
