package com.biz.crm.dms.admin.web.report.mall.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForEMS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.admin.web.report.mall.dto.HomePageProductPageDto;
import com.biz.crm.dms.admin.web.report.mall.service.HomePageProductVoService;
import com.biz.crm.dms.admin.web.report.mall.service.assist.PolicyAssist;
import com.biz.crm.dms.admin.web.report.mall.vo.HomePageProductSkuVo;
import com.biz.crm.dms.admin.web.report.mall.vo.HomePageProductVo;
import com.biz.crm.dms.admin.web.report.mall.vo.HomePageSkuPolicyVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListDmsPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListDmsVoService;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListDmsVo;
import com.biz.crm.dms.business.favorite.sdk.service.FavoriteProductService;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * impl主页产品服务
 *
 * @author hefan
 * @date 2022/04/20
 */
@Service
public class HomePageProductVoServiceImpl implements HomePageProductVoService {

  @Autowired(required = false)
  private AllowSaleListDmsVoService allowSaleListDmsVoService;
  @Autowired(required = false)
  private FavoriteProductService favoriteProductService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private PolicyAssist policyAssist;

  @Override
  public Page<HomePageProductVo> findByConditions(Pageable pageable, HomePageProductPageDto dto) {
    LoginUserDetailsForEMS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForEMS.class);
    String customerCode = loginDetails.getCustomerCode();
    // -查询允销商品
    AllowSaleListDmsPaginationDto allowSaleDto = new AllowSaleListDmsPaginationDto();
    allowSaleDto.setKeyword(dto.getKeyword());
    allowSaleDto.setBusinessCode(customerCode);
    allowSaleDto.setProductLevelCode(dto.getProductLevelCode());
    allowSaleDto.setSpuTagList(dto.getSpuTagList());
    allowSaleDto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
    Page<AllowSaleListDmsVo> allowPage = allowSaleListDmsVoService.findByConditions(pageable, allowSaleDto);
    // -查询结果判断
    Page<HomePageProductVo> page;
    if (allowPage == null) {
      page = new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
      return page;
    } else {
      page = new Page<>(allowPage.getCurrent(), allowPage.getSize(), allowPage.getTotal());
    }
    List<AllowSaleListDmsVo> records = allowPage.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return page;
    }
    // -查询到的sku 和 spu
    int size = records.size();
    Collection<String> spuCodes = new ArrayList<>(size);
    Collection<String> skuCodes = new HashSet<>(size << 2);
    for (AllowSaleListDmsVo record : records) {
      spuCodes.add(record.getSpuCode());
      List<ProductSpuRelateSkuVo> productList = record.getProductList();
      for (ProductSpuRelateSkuVo skuvo : productList) {
        String productCode = skuvo.getProductCode();
        skuCodes.add(productCode);
      }
    }
    // -查询促销政策
    Map<String, List<HomePageSkuPolicyVo>> skuCodeToVoMap = policyAssist.find(customerCode, skuCodes);
    // -查询收藏
    List<String> favoriteProduct = favoriteProductService.filterFavoriteSpuCodes(customerCode, spuCodes);
    // -构造返回内容
    List<HomePageProductVo> list = new ArrayList<>(size);
    for (AllowSaleListDmsVo record : records) {
      HomePageProductVo homePageProductVo = nebulaToolkitService.copyObjectByBlankList(record, HomePageProductVo.class, HashSet.class, LinkedList.class, "priceShowList");
      homePageProductVo.setPriceShowList(record.getPriceShowList());
      if (!CollectionUtils.isEmpty(favoriteProduct)) {
        homePageProductVo.setFavorite(favoriteProduct.contains(record.getSpuCode()));
      }
      List<HomePageProductSkuVo> productList = homePageProductVo.getProductList();
      for (HomePageProductSkuVo sku : productList) {
        sku.setPolicyVoList(skuCodeToVoMap.get(sku.getProductCode()));
      }
      list.add(homePageProductVo);
    }
    page.setRecords(list);
    return page;
  }

}
