package com.biz.crm.dms.admin.web.report.mall.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.constant.LoginUserConstant;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.dms.admin.web.report.mall.service.MallCostPoolReplenishmentOrderVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.MallCostPoolReplenishmentOrderProductVo;
import com.biz.crm.dms.admin.web.report.mall.vo.MallCostPoolReplenishmentOrderVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.service.CostPoolReplenishmentOrderVoService;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderProductVo;
import com.biz.crm.dms.business.costpool.replenishment.sdk.vo.CostPoolReplenishmentOrderVo;
import com.biz.crm.dms.business.order.minimum.local.entity.DmsOrderMinimum;
import com.biz.crm.dms.business.order.minimum.local.service.DmsOrderMinimumService;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerAddressQueryDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerAddressVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerAddressVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @Description 商城货补商品接口实现
 * @Author YangWei
 * @Date 2022/4/28 上午10:15
 */
@Service
public class MallCostPoolReplenishmentOrderVoServiceImpl implements MallCostPoolReplenishmentOrderVoService {

  @Autowired(required = false)
  private CostPoolReplenishmentOrderVoService costPoolReplenishmentOrderVoService;

  @Autowired(required = false)
  private ProductStockVoService productStockVoService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private CustomerAddressVoService customerAddressVoService;

  @Autowired(required = false)
  private WarehouseVoService warehouseVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private ProductVoService productVoService;

  @Autowired(required = false)
  private DmsOrderMinimumService dmsOrderMinimumService;

  /**
   * 商城-订单结算页面查询货补商品列表
   *
   * @param pageable
   * @param costPoolReplenishmentOrderPageDto
   * @return {@link Page}<{@link MallCostPoolReplenishmentOrderVo}>
   */
  @Override
  public Page<MallCostPoolReplenishmentOrderVo> findByCurrentCustomerAndReplenishmentPageDto(Pageable pageable
      , CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto) {
    JSONObject loginUserJson = loginUserService.getLoginUserJson();
    String customerCode = loginUserJson.getString(LoginUserConstant.FIELD_CUSTOMER_CODE);
    Page<MallCostPoolReplenishmentOrderVo> orderVoPage = new Page<>(0L, 0L, 0L);
    if (StringUtils.isBlank(customerCode)) {
      return orderVoPage;
    }
    costPoolReplenishmentOrderPageDto.setCustomerCode(customerCode);
    Page<CostPoolReplenishmentOrderVo> replenishmentPage = this.costPoolReplenishmentOrderVoService
        .findByReplenishmentPageDto(pageable, costPoolReplenishmentOrderPageDto);
    List<CostPoolReplenishmentOrderVo> records = replenishmentPage.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return orderVoPage;
    }
    //商品sku集合
    Set<String> skuCodes = Sets.newHashSet();
    records.forEach(o -> {
      o.getCostPoolReplenishmentProduct().forEach(product -> {
        skuCodes.add(product.getGoodsProductCode());
      });
    });
    // - 查询仓库
    WarehouseVo warehouse = this.findWarehouse();
    Map<String, BigDecimal> skuToAvailableMap = new HashMap<>(skuCodes.size());
    if (!ObjectUtils.isEmpty(warehouse)) {
      // - 查询库存
      List<ProductStockVo> productStockVos = productStockVoService.findByWarehouseAndProducts(warehouse.getWarehouseCode(), skuCodes);
      skuToAvailableMap = productStockVos.stream()
          .collect(Collectors.toMap(ProductStockVo::getProductCode, ProductStockVo::getAvailableStock));
    } else {
      for (String productCode : skuCodes) {
        skuToAvailableMap.put(productCode, BigDecimal.ONE);
      }
    }
    // - 起订量
    String orgCode = loginUserJson.getString(LoginUserConstant.FIELD_ORG_CODE);
    List<DmsOrderMinimum> minimums = dmsOrderMinimumService.findByCustomerCodeOrOrgCodeAndStatusInProductCodes(customerCode, orgCode, EnableStatusEnum.ENABLE.getCode(), skuCodes);
    Map<String, BigDecimal> skuToMinimunMap = new HashMap<>(minimums.size());
    for (DmsOrderMinimum minimum : minimums) {
      skuToMinimunMap.put(minimum.getProductCode(), minimum.getMinimum());
    }
    // 查询可购的商品
    Set<String> allowSaleProductCodes = this.findAllowSaleProductCodes(customerCode, Lists.newArrayList(skuCodes));
    //构建返回结果
    return buildMallReplenishmentResult(orderVoPage, skuToAvailableMap, skuToMinimunMap, replenishmentPage, allowSaleProductCodes);
  }

  /**
   * 构建货补商品返回结果
   *
   * @param orderVoPage
   * @param skuToAvailableMap
   * @param skuToMinimunMap
   * @param replenishmentPage
   * @param allowSaleProductCodes
   * @return {@link Page}<{@link MallCostPoolReplenishmentOrderVo}>
   */
  private Page<MallCostPoolReplenishmentOrderVo> buildMallReplenishmentResult(
      Page<MallCostPoolReplenishmentOrderVo> orderVoPage, Map<String, BigDecimal> skuToAvailableMap,
      Map<String, BigDecimal> skuToMinimunMap, Page<CostPoolReplenishmentOrderVo> replenishmentPage, Set<String> allowSaleProductCodes) {
    //分页数据
    orderVoPage.setTotal(replenishmentPage.getTotal());
    orderVoPage.setCurrent(replenishmentPage.getCurrent());
    orderVoPage.setSize(replenishmentPage.getSize());
    orderVoPage.setPages(replenishmentPage.getPages());
    //返回结果集合
    List<MallCostPoolReplenishmentOrderVo> orderVos = Lists.newArrayList();
    replenishmentPage.getRecords().forEach(o -> {
      MallCostPoolReplenishmentOrderVo replenishmentOrderVo = this.nebulaToolkitService
          .copyObjectByBlankList(o, MallCostPoolReplenishmentOrderVo.class, HashSet.class, LinkedList.class);
      //商品集合
      List<MallCostPoolReplenishmentOrderProductVo> replenishmentOrderProductVoList =
          (List<MallCostPoolReplenishmentOrderProductVo>) this.nebulaToolkitService
              .copyCollectionByWhiteList(o.getCostPoolReplenishmentProduct(), CostPoolReplenishmentOrderProductVo.class,
                  MallCostPoolReplenishmentOrderProductVo.class, HashSet.class, LinkedList.class);
      //查询商品上下架状态
      List<String> productCodes = replenishmentOrderProductVoList.stream()
          .map(MallCostPoolReplenishmentOrderProductVo::getGoodsProductCode).collect(Collectors.toList());
      List<ProductVo> byProductLevelCodes = productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
      Map<String, ProductVo> productMap = byProductLevelCodes.stream()
          .filter(e -> StringUtils.isNotBlank(e.getProductCode()))
          .filter(e -> StringUtils.isNotBlank(e.getIsShelf()))
          .collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (v1, v2) -> v1));
      //赋值起订量,库存,上下架状态,图片视频附件信息
      replenishmentOrderProductVoList.forEach(product -> {
        String goodsProductCode = product.getGoodsProductCode();
        product.setAvailableStock(skuToAvailableMap.get(goodsProductCode));
        product.setMinimum(skuToMinimunMap.get(goodsProductCode));
        ProductVo productVo = productMap.get(goodsProductCode);
        if (!ObjectUtils.isEmpty(productVo)) {
          product.setIsShelf(productVo.getIsShelf());
          product.setEnableStatus(productVo.getEnableStatus());
          product.setPictureMediaList(productVo.getPictureMediaList());
          product.setVideoMediaList(productVo.getVideoMediaList());
        }
        product.setIsAllowsale(allowSaleProductCodes.contains(goodsProductCode));
      });
      replenishmentOrderVo.setMallCostPoolReplenishmentProduct(replenishmentOrderProductVoList);
      orderVos.add(replenishmentOrderVo);
    });
    orderVoPage.setRecords(orderVos);
    return orderVoPage;
  }

  @Autowired(required = false)
  private AllowSaleListVoService allowSaleListVoService;

  /**
   * 找到允许出售产品Code
   *
   * @param customerCode 客户代码
   * @param productCodes 产品代码
   * @return {@link List}<{@link String}>
   */
  private Set<String> findAllowSaleProductCodes(String customerCode, List<String> productCodes) {
    ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
    dto.setBusinessCode(customerCode);
    dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
    dto.setProductCodeList(productCodes);
    List<String> list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
    return Sets.newHashSet(list);
  }

  /**
   * 查询仓库
   *
   * @return {@link WarehouseVo}
   */
  private WarehouseVo findWarehouse() {
    /**
     * - 查询当前登录经销商的默认收货地址认
     * - 如果没有收货地址就用默认仓库
     * - 如果有说货地址还是没有查到仓库，就用默认仓库
     */
    JSONObject loginUserJson = loginUserService.getLoginUserJson();
    String customerCode = loginUserJson.getString(LoginUserConstant.FIELD_CUSTOMER_CODE);
    // - 查询客户的默认的有效的收货地址
    String cityCode = this.findCityCode(customerCode);
    WarehouseVo warehouse = null;
    if (StringUtils.isBlank(cityCode)) {
      warehouse = warehouseVoService.findDetailsByWarehouseDefault(true);
    } else {
      warehouse = warehouseVoService.findDetailsByCityCode(cityCode);
      if (warehouse == null) {
        warehouse = warehouseVoService.findDetailsByWarehouseDefault(true);
      }
    }
    Validate.notNull(warehouse, "没有找到仓库信息");
    return warehouse;
  }

  /**
   * 查询当前经销商登录者的默认地址的cityCode
   *
   * @param customerCode 客户代码
   * @return {@link String}
   */
  private String findCityCode(String customerCode) {
    CustomerAddressQueryDto customerAddressQueryDto = new CustomerAddressQueryDto();
    customerAddressQueryDto.setDefaultAddress(true);
    customerAddressQueryDto.setCustomerCode(customerCode);
    customerAddressQueryDto.setTenantCode(TenantUtils.getAppCode());
    List<CustomerAddressVo> customerAddressList = this.customerAddressVoService.findByCustomerAddressQueryDto(customerAddressQueryDto);
    if (CollectionUtils.isEmpty(customerAddressList)) {
      return null;
    }
    for (CustomerAddressVo addressVo : customerAddressList) {
      return addressVo.getCityCode();
    }
    return null;
  }
}