package com.biz.crm.dms.admin.web.report.mall.vo;

import com.biz.crm.mdm.business.product.sdk.vo.ProductIntroductionVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 首页产品SPU下的SKU
 *
 * @author hefan
 * @date 2022/04/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "首页产品SPU下的SKU")
public class HomePageProductSkuVo {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /** 商品sku编码 */
  @ApiModelProperty("商品sku编码")
  private String productCode;

  /** 商品sku名称 */
  @ApiModelProperty("商品sku名称")
  private String productName;

  /** 商品sku类型 */
  @ApiModelProperty("商品sku类型")
  private String productType;

  /** 产品层级 */
  @ApiModelProperty("产品层级")
  private String productLevelName;

  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;

  /** 销售单位 */
  @ApiModelProperty("销售单位")
  private String unite;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 价格 */
  @ApiModelProperty("价格")
  private BigDecimal price;

  /** 开始时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("开始时间")
  private Date beginDateTime;

  /** 结束时间 */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("结束时间")
  private Date endDateTime;

  /** 图片信息 */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaVo> pictureMediaList;

  /** 视频信息 */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaVo> videoMediaList;

  /** 商品介绍 */
  @ApiModelProperty("商品介绍-富文本")
  private ProductIntroductionVo introduction;

  /**
   * 促销政策
   */
  @ApiModelProperty("促销政策")
  List<HomePageSkuPolicyVo> policyVoList;

}
