package com.biz.crm.dms.admin.web.report.mall.vo;

import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 货补商品明细
 * @Author YangWei
 * @Date 2022/4/28 上午10:10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用于订单新增货补产品VO")
public class MallCostPoolReplenishmentOrderProductVo implements Serializable {
  private static final long serialVersionUID = 5861949401821406881L;
  /**
   * 货补池产品子表ID
   */
  @ApiModelProperty(value = "货补池产品子表ID")
  private String id;
  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;
  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String productLevelCode;
  /**
   * 货补商品编码
   */
  @ApiModelProperty(value = "货补商品编码")
  private String goodsProductCode;
  /**
   * 货补商品名称
   */
  @ApiModelProperty(value = "货补商品名称")
  private String goodsProductName;
  /**
   * 商品单价
   */
  @ApiModelProperty("商品单价")
  private BigDecimal price;

  /** 规格 */
  @ApiModelProperty("规格")
  private String spec;

  /** 基本单位 */
  @ApiModelProperty("基本单位")
  private String baseUnit;

  /** 销售单位 */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 起订量
   */
  @ApiModelProperty(name = "minimum", value = "起订量")
  private BigDecimal minimum;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /** 是否允销 */
  @ApiModelProperty("是否允销")
  private Boolean isAllowsale;

  /** 上下架状态 */
  @ApiModelProperty("上下架状态")
  private String enableStatus;
  /**
   * 可用库存
   */
  @ApiModelProperty("可用库存")
  private BigDecimal availableStock;

  /** 图片信息 */
  @ApiModelProperty("附件信息，图片信息")
  private List<ProductMediaVo> pictureMediaList;

  /** 视频信息 */
  @ApiModelProperty("附件信息，视频信息")
  private List<ProductMediaVo> videoMediaList;
}