package com.biz.crm.dms.admin.web.report.mall.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @Description 商城货补商品VO
 * @Author YangWei
 * @Date 2022/4/28 上午10:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商城订单结算货补产品时VO")
public class MallCostPoolReplenishmentOrderVo implements Serializable {
  private static final long serialVersionUID = -4937301335523858032L;
  /**
   * 货补池主表ID
   */
  @ApiModelProperty(value = "货补池主表ID")
  private String id;

  /**
   * 费用池编号
   */
  @ApiModelProperty(value = "费用池编号")
  private String poolCode;

  /**
   * 费用池分组
   */
  @ApiModelProperty(value = "费用池分组")
  private String poolGroup;

  /**
   * 费用池类型
   */
  @ApiModelProperty(value = "费用池类型")
  private String poolType;

  /**
   * 支付方式
   */
  @ApiModelProperty(value = "支付方式")
  private String payType;

  /**
   * 费用使用类型
   */
  @ApiModelProperty(value = "费用使用类型")
  private String useType;

  /**
   * 客户编码
   */

  @ApiModelProperty(value = "客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String customerName;

  /**
   * 渠道类型（项目上自行存值）
   */
  @ApiModelProperty(value = "渠道类型")
  private String channelType;

  /**
   * 组织编码（项目上自行存值）
   */
  @ApiModelProperty(value = "组织编码")
  private String orgCode;

  /**
   * 组织名称（项目上自行存值）
   */
  @ApiModelProperty(value = "组织名称")
  private String orgName;

  /**
   * 货补产品层级编码
   */
  @ApiModelProperty(value = "货补产品层级编码")
  private String goodsProductLevelCode;

  /**
   * 货补产品层级名称
   */
  @ApiModelProperty(value = "货补产品层级名称")
  private String goodsProductLevelName;

  /**
   * 总金额（数量）
   */
  @ApiModelProperty(value = "总金额")
  private BigDecimal totalAmount;

  /**
   * 冻结金额（数量）
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal freezeAmount;

  /**
   * 占用金额（数量）
   */
  @ApiModelProperty(value = "占用金额")
  private BigDecimal occupyAmount;

  /**
   * 已使用金额（数量）
   */
  @ApiModelProperty(value = "已使用金额")
  private BigDecimal hasUseAmount;

  /**
   * 剩余可使用金额（数量）
   */
  @ApiModelProperty(value = "剩余可使用金额")
  private BigDecimal usableAmount;

  /**
   * 货补商品
   */
  @ApiModelProperty(value = "货补商品")
  private List<MallCostPoolReplenishmentOrderProductVo> mallCostPoolReplenishmentProduct;
}