package com.biz.crm.dms.admin.web.report.mall.vo;

import com.biz.crm.business.common.sdk.vo.WorkflowFlagOpVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderFileVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderPayVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 商城订单Vo
 *
 * @author hefan
 * @date 2022/05/14
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商城订单Vo")
public class MallOrderVo extends WorkflowFlagOpVo {

  /**
   * 订单编码
   */
  @ApiModelProperty("订单编码")
  private String orderCode;

  /**
   * 原始订单编码
   */
  @ApiModelProperty("原始订单编码")
  private String originalOrderCode;

  /**
   * 订单来源
   */
  @ApiModelProperty("订单来源")
  private String orderSource;

  /**
   * 订单类别：销售订单、物料订单
   */
  @ApiModelProperty("订单类别")
  private String orderCategory;

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 订单状态
   */
  @ApiModelProperty("订单状态")
  private String orderStatus;

  /**
   * 关联编码 【客户编码】
   */
  @ApiModelProperty("关联编码 【客户编码】")
  private String relateCode;

  /**
   * 关联名称 【客户名称】
   */
  @ApiModelProperty("关联名称 【客户名称】")
  private String relateName;

  /**
   * 提货方式
   */
  @ApiModelProperty("提货方式")
  private String pickUpWay;

  /**
   * 收货地址 == 详细地址
   */
  @ApiModelProperty("收货地址 == 详细地址 ")
  private String detailedAddress;

  /**
   * 仓库编码 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库编码")
  private String warehouseCode;

  /**
   * 仓库名称 - 因为物料订单需要指定仓库
   */
  @ApiModelProperty("仓库名称")
  private String warehouseName;

  /**
   * 联系人
   */
  @ApiModelProperty("联系人")
  private String contactName;

  /**
   * 联系方式 == 联系电话
   */
  @ApiModelProperty("联系方式 == 联系电话")
  private String contactPhone;

  /**
   * 交货日期
   */
  @ApiModelProperty("交货日期")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  private Date deliveryDate;

  /**
   * 省编码
   */
  @ApiModelProperty("省编码")
  private String provinceCode;

  /**
   * 市编码
   */
  @ApiModelProperty("市编码")
  private String cityCode;

  /**
   * 区编码
   */
  @ApiModelProperty("区编码")
  private String districtCode;

  /**
   * 商品数量
   */
  @ApiModelProperty("商品数量")
  private BigDecimal quantityOfCommodity;

  /**
   * 发货数量
   */
  @ApiModelProperty("发货数量")
  private BigDecimal deliveryQuantity;

  /**
   * 收货状态
   */
  @ApiModelProperty("收货状态")
  private String receiptStatus;

  /**
   * 订单总金额
   */
  @ApiModelProperty("订单总金额")
  @Column(name = "total_order_amount", columnDefinition = "decimal(20,4) COMMENT '订单总金额'")
  private BigDecimal totalOrderAmount;

  /**
   * 本单实际支付 == 实际支付金额
   */
  @ApiModelProperty("本单实际支付 == 实际支付金额")
  private BigDecimal actualAmountPaid;

  /**
   * 是否揉价（0：否；1：是）
   */
  @ApiModelProperty("是否揉价（0：否；1：是）")
  private Boolean splitPrice;

  /**
   * 暂存的草稿（0：否；1：是）
   */
  @ApiModelProperty("暂存的草稿（0：否；1：是）")
  private Boolean draft;

  /**
   * 期望到货时间
   */
  @ApiModelProperty("期望到货时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
  private Date expectedArrivalTime;

  /**
   * 开票状态
   */
  @ApiModelProperty("开票状态")
  private String invoiceStatus;

  /**
   * 订单的总的记账项目
   */
  @ApiModelProperty("订单的总的记账项目")
  private List<OrderPayVo> orderPays;

  /**
   * 存放订单里的货物
   */
  @ApiModelProperty("订单明细 == 存放订单里的货物")
  private List<MallOrderDetailVo> orderDetails;

  /**
   * 订单附件信息
   */
  @ApiModelProperty("订单附件信息")
  private List<OrderFileVo> orderFiles;

}
