package com.biz.crm.dms.admin.web.imports.stockcustomer.service;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.dms.admin.web.imports.stockcustomer.model.StockStatisticsImportVo;
import com.biz.crm.dms.business.stock.customer.sdk.dto.StockStatisticsDto;
import com.biz.crm.dms.business.stock.customer.sdk.service.StockStatisticsVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年07月29日 16:31:00
 */
@Component
public class StockStatisticsImportProcess implements ImportProcess<StockStatisticsImportVo> {

  /**
   * 默认来源，调整类型，操作类型
   */
  private static final String DEFAULT_ADJUST_TYPE="stock_update";
  private static final String DEFAULT_OP_TYPE="stock_statistics";
  private static final String DEFAULT_OP_SOURCE="经销商库存提报";

  @Autowired
  private StockStatisticsVoService stockStatisticsVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Map<Integer, String> execute(LinkedHashMap<Integer, StockStatisticsImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
    List<StockStatisticsImportVo> values =(List<StockStatisticsImportVo>) data.values();
    if (CollectionUtils.isEmpty(values)){
      return null;
    }
    List<String> collect = values.stream().map(e -> e.getCusCode().concat(e.getProductCode())).distinct().collect(Collectors.toList());
    Validate.isTrue(collect.size()==values.size(),"重复行数据");
    List<StockStatisticsDto> res =(List<StockStatisticsDto>) this.nebulaToolkitService.copyCollectionByWhiteList(values,StockStatisticsImportVo.class,StockStatisticsDto.class, HashSet.class, ArrayList.class);
    //填充数据
    for (StockStatisticsDto re : res) {
      re.setAdjustType(DEFAULT_ADJUST_TYPE);
      re.setOperationSource(DEFAULT_OP_SOURCE);
      re.setOperationType(DEFAULT_OP_TYPE);
    }
    this.stockStatisticsVoService.create(res);
    return null;
  }

  @Override
  public Class<StockStatisticsImportVo> findCrmExcelVoClass() {
    return StockStatisticsImportVo.class;
  }

  @Override
  public String getTemplateCode() {
    return "DMS_STOCK_STATISTICS_IMPORT";
  }

  @Override
  public String getTemplateName() {
    return "库存提报导入";
  }
}
