package com.biz.crm.dms.admin.web.login.refresh;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.dms.admin.web.login.DefaultPerfectLoginUserDetails;
import com.biz.crm.mdm.business.user.sdk.service.UserValidityCheckService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.refresh.AuthenticationRefreshStrategy;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * 导入导出任务所需要的用户身份初始化动作
 *
 * @author sunx yinwenjie
 * @since 2022-08-28 由银文杰进行修改
 */
@Component
public class ImportExportAuthenticationRefreshStrategy extends DefaultPerfectLoginUserDetails implements AuthenticationRefreshStrategy {

  /** nebula security模块中，关于默认用户身份信息的配置情况 */
  @Autowired 
  private SimpleSecurityProperties simpleSecurityProperties;
  @Autowired
  @Lazy
  private UserValidityCheckService userValidityCheckService;
  
  @Override
  public int getOrder() {
    return 8;
  }

  @Override
  public boolean matched(Object info) {
    if(info != null && (info instanceof TaskGlobalParamsVo)) {
      return true;
    }
    return false;
  }

  /**
   * 根据导入导出任务公共信息设置登录信息
   *
   * @deprecated 需要在导入导出方面提供相关的支持
   *
   * @param vo 任务参数vo
   */
  @Override
  public UserIdentity refresh(Object info) {
    TaskGlobalParamsVo vo = (TaskGlobalParamsVo)info;
    String account = this.simpleSecurityProperties.getIndependencyUser();
    String userName = "超级管理员";
    if (StringUtils.isNotBlank(vo.getCreateAccount())) {
      account = vo.getCreateAccount();
    }
    if (StringUtils.isNotBlank(vo.getCreateAccountName())) {
      userName = vo.getCreateAccountName();
    }
    if (StringUtils.isNotBlank(vo.getAppCode())) {
      TenantContextHolder.setApp(vo.getAppCode());
    }
    if (StringUtils.isNotBlank(vo.getTenantCode())) {
      TenantContextHolder.setTenant(vo.getTenantCode());
    }
    String tenantCode = TenantUtils.getTenantCode();
    if (StringUtils.isBlank(tenantCode)) {
      TenantContextHolder.setTenant("default");
    }
    String[] roles = this.simpleSecurityProperties.getIndependencyRoles();
    Integer type = this.simpleSecurityProperties.getDefaultLoginType();
    
    // 初始化用户
    UserVo userVo = this.userValidityCheckService.verificationManageByAccount(account);
    FacturerUserDetails facturer = new FacturerUserDetails();
    facturer.setAccount(account);
    // 厂商用户（超级管理员）
    facturer.setLoginType(type);
    facturer.setIdentityType("u");
    facturer.setRoleCodes(roles);
    facturer.setUsername(userName);
    facturer.setTenantCode(TenantUtils.getTenantCode());
    super.perfectLoginUserDetails(userVo, facturer);
    super.perfectLoginPostAndOrg(facturer);
    return facturer;
  }
}
