package com.biz.crm.dms.admin.web.report.contract.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.contract.service.ContractProductCoverVoService;
import com.biz.crm.dms.admin.web.report.contract.vo.ContractProductCoverVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 合同及商品封面
 *
 * @author pengxi
 * @date 2022/09/17
 */
@RestController
@RequestMapping("/v1/report/contractProductCover")
@Slf4j
@Api(tags = "商城报表：ContractProductCoverVo：合同及商品封面")
public class ContractProductCoverVoController {

  @Autowired(required = false)
  private ContractProductCoverVoService contractProductCoverVoService;

  /**
   * 根据客户编码查询合同及商品封面
   *
   * @param customerCode 客户编码
   * @return Result<List<ContractProductCoverVo>>
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByCustomerCode")
  public Result<List<ContractProductCoverVo>> findByCustomerCode(@ApiParam(name = "customerCode", value = "客户编码") String customerCode) {
    try {
      List<ContractProductCoverVo> contractProductCoverVos = this.contractProductCoverVoService.findByCustomerCode(customerCode);
      return Result.ok(contractProductCoverVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
