package com.biz.crm.dms.admin.web.report.contract.service.internal;

import com.biz.crm.dms.admin.web.report.contract.service.ContractProductCoverVoService;
import com.biz.crm.dms.admin.web.report.contract.vo.ContractProductCoverVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.service.AllowSaleElementVoService;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleElementEnums;
import com.biz.crm.dms.business.contract.sdk.service.ContractVoService;
import com.biz.crm.dms.business.contract.sdk.vo.contract.ContractVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductMediaVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 合同及产品封面
 *
 * @author pengxi
 * @date 2022/09/17
 */
@Service
public class ContractProductCoverVoServiceImpl implements ContractProductCoverVoService {

  @Autowired(required = false) private ContractVoService contractVoService;

  @Autowired(required = false) private ProductVoService productVoService;

  @Autowired(required = false) private ProductMediaVoService productMediaVoService;

  @Autowired(required = false) private AllowSaleElementVoService allowSaleElementVoService;

  @Autowired(required = false) @Qualifier("nebulaToolkitService") private NebulaToolkitService nebulaToolkitService;

  @Override
  public List<ContractProductCoverVo> findByCustomerCode(String customerCode) {
    List<ContractVo> contractVos = this.contractVoService.findEffectiveByCustomerCode(customerCode);
    if (CollectionUtils.isEmpty(contractVos)) {
      return Lists.newArrayList();
    }
    List<ContractProductCoverVo> contractProductCoverVoList = (List<ContractProductCoverVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
        contractVos, ContractVo.class, ContractProductCoverVo.class, HashSet.class, ArrayList.class);
    Map<String, ContractProductCoverVo> contractProductCoverVoMap = contractProductCoverVoList.stream().collect(Collectors.toMap(ContractProductCoverVo::getContractCode, Function.identity()));
    List<AllowSaleElementVo> allowSaleElementVos = this.allowSaleElementVoService.findByContractCodeList(contractVos.stream().map(ContractVo::getContractCode).collect(Collectors.toList()));
    if (CollectionUtils.isEmpty(allowSaleElementVos)) {
      return contractProductCoverVoList;
    }
    Set<String> productCodes = new HashSet<>();
    //可购类型为商品sdk
    Set<String> productCodesByType = allowSaleElementVos.stream().filter(ase -> AllowSaleElementEnums.PRODUCT.getCode().equals(ase.getAllowSaleType())).map(AllowSaleElementVo::getProductCode).collect(Collectors.toSet());
    if (CollectionUtils.isNotEmpty(productCodesByType)) {
      productCodes.addAll(productCodesByType);
    }
    //可购类型为商品层级
    Set<String> productLevelCodesByType = allowSaleElementVos.stream().filter(ase -> AllowSaleElementEnums.PRODUCT_LEVEL.getCode().equals(ase.getAllowSaleType())).map(AllowSaleElementVo::getProductLevelCode).collect(Collectors.toSet());
    Set<ProductVo> productVoSetByLevel = Sets.newConcurrentHashSet();
    if (CollectionUtils.isNotEmpty(productLevelCodesByType)) {
      List<ProductVo> productVoList = this.productVoService.findByProductLevelCodes(new ArrayList<>(productLevelCodesByType));
      if (CollectionUtils.isNotEmpty(productVoList)) {
        productVoSetByLevel.addAll(productVoList);
        Set<String> productCodesSet = productVoList.stream().map(ProductVo::getProductCode).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(productCodesSet)) {
          productCodes.addAll(productCodesSet);
        }
      }
    }
    // 根据产品层级查出来的商品再转换成以产品层级为key的map结构
    Map<String, List<ProductVo>> productVoMapByLevel = productVoSetByLevel.stream().collect(Collectors.groupingBy(ProductVo::getProductLevelCode));
    if (CollectionUtils.isEmpty(productCodes)) {
      return contractProductCoverVoList;
    }
    // 查商品附件
    List<ProductMediaVo> productMediaVos = this.productMediaVoService.findByProductCodes(new ArrayList<>(productCodes));
    Map<String, List<ProductMediaVo>> productMediaVoMap = Optional.ofNullable(productMediaVos).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
    if (MapUtils.isEmpty(productMediaVoMap)) {
      return contractProductCoverVoList;
    }
    allowSaleElementVos.forEach(ase->{
      ContractProductCoverVo contractProductCoverVo = contractProductCoverVoMap.get(ase.getContractcode());
      //可购类型为商品层级
      if (AllowSaleElementEnums.PRODUCT_LEVEL.getCode().equals(ase.getAllowSaleType())) {
        List<ProductVo> productVos = productVoMapByLevel.get(ase.getProductLevelCode());
        if (CollectionUtils.isEmpty(productVos)) {
          return;
        }
        Set<String> elementProductCodeSet = productVos.stream().map(ProductVo::getProductCode).collect(Collectors.toSet());
        elementProductCodeSet.forEach(elementProductCode->{
          List<ProductMediaVo> productMediaVoList = productMediaVoMap.get(elementProductCode);
          if (CollectionUtils.isEmpty(productMediaVoList)) {
            return;
          }
          contractProductCoverVo.getProductCoverList().add(productMediaVoList.get(0));
        });
      }
      //可购类型为商品sdk
      if (AllowSaleElementEnums.PRODUCT.getCode().equals(ase.getAllowSaleType())) {
        List<ProductMediaVo> productMediaVoList = productMediaVoMap.get(ase.getProductCode());
        if (CollectionUtils.isEmpty(productMediaVoList)) {
          return;
        }
        contractProductCoverVo.getProductCoverList().add(productMediaVoList.get(0));
      }
      contractProductCoverVoMap.put(contractProductCoverVo.getContractCode(), contractProductCoverVo);
    });
    return new ArrayList<>(contractProductCoverVoMap.values());
  }
}
