package com.biz.crm.dms.admin.web.report.contract.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.admin.web.report.contract.dto.ContractProductSkuPageDto;
import com.biz.crm.dms.admin.web.report.contract.service.ContractProductSkuVoService;
import com.biz.crm.dms.admin.web.report.contract.vo.ContractProductSkuVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.service.AllowSaleElementVoService;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleElementEnums;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductMediaVoService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductMediaVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 合同产品sku
 *
 * @author hefan
 * @date 2022/09/13
 */
@Service
public class ContractProductSkuVoServiceImpl implements ContractProductSkuVoService {

  @Autowired(required = false) private ProductVoService productVoService;

  @Autowired(required = false) private ProductMediaVoService productMediaVoService;

  @Autowired(required = false) private AllowSaleElementVoService allowSaleElementVoService;

  @Autowired(required = false) private ProductLevelVoSdkService productLevelVoSdkService;

  @Autowired(required = false) @Qualifier("nebulaToolkitService") private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<ContractProductSkuVo> findByConditions(Pageable pageable, ContractProductSkuPageDto contractProductSkuPageDto) {
    Page<ContractProductSkuVo> contractProductSkuVoPage = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    AllowSaleElementDataVo allowSaleElementDataVo = this.allowSaleElementVoService.findByContractCode(contractProductSkuPageDto.getContractCode());
    if (allowSaleElementDataVo == null) {
      return contractProductSkuVoPage;
    }
    Map<String, List<AllowSaleElementVo>> allowSaleMap = allowSaleElementDataVo.getAllowSaleMap();
    List<AllowSaleElementVo> productList = allowSaleMap.get(AllowSaleElementEnums.PRODUCT.getCode());
    List<AllowSaleElementVo> productLevelList = allowSaleMap.get(AllowSaleElementEnums.PRODUCT_LEVEL.getCode());
    ProductPaginationDto productPaginationDto = new ProductPaginationDto();
    if (CollectionUtils.isNotEmpty(productList)) {
      productPaginationDto.setProductCodes(productList.stream().map(AllowSaleElementVo::getProductCode).collect(Collectors.toSet()));
    }
    if (CollectionUtils.isNotEmpty(productLevelList)) {
      Set<String> productLevels = productLevelList.stream().map(AllowSaleElementVo::getProductLevelCode).collect(Collectors.toSet());
      List<String> productLevelCodes = productLevelVoSdkService.findCurAndChildrenCodesByCodes(productLevels);
      Set<String> productLevelCodeSets = productLevelCodes.stream().collect(Collectors.toSet());
      productPaginationDto.setProductLevelCodes(productLevelCodeSets);
    }
    productPaginationDto.setKeyword(contractProductSkuPageDto.getKeyword());
    Page<ProductVo> productVoPage = this.productVoService.findByConditions(pageable, productPaginationDto);
    if (CollectionUtils.isEmpty(productVoPage.getRecords())) {
      return contractProductSkuVoPage;
    }
    List<ContractProductSkuVo> contractProductSkuVoList = (List<ContractProductSkuVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
        productVoPage.getRecords(), ProductVo.class, ContractProductSkuVo.class, HashSet.class, ArrayList.class);
    // 查附件
    List<ProductMediaVo> productMediaVos = this.productMediaVoService.findByProductCodes(contractProductSkuVoList.stream().map(ContractProductSkuVo::getProductCode).collect(Collectors.toList()));
    Map<String, List<ProductMediaVo>> productMediaVoMap = Optional.ofNullable(productMediaVos).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(ProductMediaVo::getProductCode));
    contractProductSkuVoList.forEach(productVo->{
      if (MapUtils.isNotEmpty(productMediaVoMap)) {
        productVo.setPictureMediaList(productMediaVoMap.get(productVo.getProductCode()));
      }
    });
    contractProductSkuVoPage.setRecords(contractProductSkuVoList);
    return contractProductSkuVoPage;
  }

}
