package com.biz.crm.dms.admin.web.report.mall.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.mall.dto.HomePageProductPageDto;
import com.biz.crm.dms.admin.web.report.mall.service.HomePageProductVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.HomePageProductVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 首页商品
 *
 * @author hefan
 * @date 2022/04/20
 */
@RestController
@RequestMapping("/v1/report/homePageProduct")
@Slf4j
@Api(tags = "商城报表：HomePageProductVo：商城首页商品")
public class HomePageProductVoController {

  @Autowired(required = false)
  private HomePageProductVoService homePageProductService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<HomePageProductVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "order", value = "订单主信息") HomePageProductPageDto dto) {
    try {
      Page<HomePageProductVo> page = this.homePageProductService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
