package com.biz.crm.dms.admin.web.report.mall.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.mall.service.MallCostPoolReplenishmentOrderVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.MallCostPoolReplenishmentOrderVo;
import com.biz.crm.dms.business.costpool.replenishment.sdk.dto.CostPoolReplenishmentOrderPageDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description 商城货补商品
 * @Author YangWei
 * @Date 2022/4/28 上午10:06
 */
@RestController
@RequestMapping("/v1/replenishment/costPoolReplenishment")
@Slf4j
@Api(tags = "用于商城订单结算新增货补产品时提供接口")
public class MallCostPoolReplenishmentOrderVoController {

  @Autowired(required = false)
  private MallCostPoolReplenishmentOrderVoService mallCostPoolReplenishmentOrderVoService;

  /**
   * 商城-订单结算页面查询货补商品列表
   * @param pageable
   * @param costPoolReplenishmentOrderPageDto
   * @return {@link Result}<{@link Page}<{@link MallCostPoolReplenishmentOrderVo}>>
   */
  @ApiOperation(value = "商城-订单结算页面查询货补商品列表")
  @GetMapping("findByCurrentCustomerAndReplenishmentPageDto")
  public Result<Page<MallCostPoolReplenishmentOrderVo>> findByCurrentCustomerAndReplenishmentPageDto(
      @ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "costPoolReplenishment", value = "货补费用池主表") CostPoolReplenishmentOrderPageDto costPoolReplenishmentOrderPageDto) {
    try {
      Page<MallCostPoolReplenishmentOrderVo> page = this.mallCostPoolReplenishmentOrderVoService.findByCurrentCustomerAndReplenishmentPageDto(pageable, costPoolReplenishmentOrderPageDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}