package com.biz.crm.dms.admin.web.report.mall.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.admin.web.report.mall.dto.HomePageProductPageDto;
import com.biz.crm.dms.admin.web.report.mall.service.MallProductSpuVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.MallProductSpuVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商城产品spu vo控制器
 *
 * @author hefan
 * @date 2022/05/17
 */
@RestController
@RequestMapping("/v1/report/mallProduct")
@Slf4j
@Api(tags = "商城报表：MallProductSpuVo：商城商品")
public class MallProductSpuVoController {

  @Autowired(required = false)
  private MallProductSpuVoService mallProductSpuVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<MallProductSpuVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                         @ApiParam(name = "order", value = "订单主信息") HomePageProductPageDto dto) {
    try {
      Page<MallProductSpuVo> page = this.mallProductSpuVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
