package com.biz.crm.dms.admin.web.report.mall.service;

import com.biz.crm.dms.admin.web.report.mall.vo.ProductWithMiniAndStockVo;

/**
 * 具有最小起订量和库存的商品
 *
 * @author hefan
 * @date 2022/04/22
 */
public interface ProductWithMiniAndStockVoService {
  /**
   * 根据spuCode查询
   *
   * @param spuCode spu代码
   * @param isFuzzy true代表在查询可购清单时进行模糊搜索 false代表在查询胡可够清单时补进行模糊搜索
   * @return {@link ProductWithMiniAndStockVo}
   */
  ProductWithMiniAndStockVo findBySpuCode(String spuCode, Boolean isFuzzy, String customerCode);

  /**
   * 根据spuCode查询（含促销政策）
   *
   * @param spuCode spu代码
   * @return {@link ProductWithMiniAndStockVo}
   */
  ProductWithMiniAndStockVo findJoinPolicyBySpuCode(String spuCode, String customerCode);
}
