package com.biz.crm.dms.admin.web.report.mall.service.assist;

import com.biz.crm.dms.admin.web.report.mall.vo.HomePageSkuPolicyVo;
import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.SalePolicyConProduct;
import com.biz.crm.dms.business.policy.sdk.service.SalePolicyExecuteService;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 政策辅助类
 *
 * @author hefan
 * @date 2022/05/11
 */
@Component
public class PolicyAssist {

  @Autowired(required = false)
  private SalePolicyExecuteService<DefaultPolicyExecuteContext> salePolicyExecuteService;

  /**
   * 找到
   *
   * @param customerCode 客户编码
   * @param productCodes skuCode集合
   * @return {@link Map}<{@link String}, {@link List}<{@link HomePageSkuPolicyVo}>>
   */
  public Map<String, List<HomePageSkuPolicyVo>> find(String customerCode, Collection<String> productCodes) {
    if (CollectionUtils.isEmpty(productCodes)) {
      return new HashMap<>(0);
    }
    // - 调用促销政策预判
    Set<SalePolicyConProduct> salePolicyConProducts = new HashSet<>(productCodes.size());
    for (String productCode : productCodes) {
      SalePolicyConProduct salePolicyConProduct = new SalePolicyConProduct();
      salePolicyConProduct.setProductCode(productCode);
      salePolicyConProduct.setQuantity(BigDecimal.ONE);
      salePolicyConProduct.setUnitPrice(BigDecimal.ONE);
      salePolicyConProduct.setSubtotalAmount(BigDecimal.ONE);
      salePolicyConProducts.add(salePolicyConProduct);
    }
    // fixme 经销商与品牌方的这个属性需要再固定逻辑
    String tenantCode = TenantUtils.getTenantCode();
    DefaultPolicyExecuteContext context = salePolicyExecuteService.preJudgment(salePolicyConProducts, tenantCode, customerCode);
    if (ObjectUtils.isEmpty(context)) {
      return Maps.newHashMap();
    }
    // - key:skuCode , value: policyCodes
    Map<String, Set<String>> matchedProductInfoMapping = context.getMatchedProductInfoMapping();
    // - 政策信息
    Set<SalePolicyVo> initSalePolices = context.getInitSalePolicys();
    // - 给政策信息创建索引：policyCode
    Map<String, SalePolicyVo> policyCodeToPolicyVoMap = new HashMap<>(initSalePolices.size());
    for (SalePolicyVo salePolicyVo : initSalePolices) {
      policyCodeToPolicyVoMap.put(salePolicyVo.getSalePolicyCode(), salePolicyVo);
    }
    // - key:skuCode , value: HomePageSkuPolicyVoList
    Map<String, List<HomePageSkuPolicyVo>> map = new HashMap<>(productCodes.size());
    for (String productCode : productCodes) {
      List<HomePageSkuPolicyVo> policyVoList = Lists.newArrayList();
      Set<String> policyCodes = matchedProductInfoMapping.get(productCode);
      if (CollectionUtils.isEmpty(policyCodes)) {
        continue;
      }
      for (String policyCode : policyCodes) {
        SalePolicyVo salePolicyVo = policyCodeToPolicyVoMap.get(policyCode);
        HomePageSkuPolicyVo vo = new HomePageSkuPolicyVo();
        vo.setType(salePolicyVo.getType());
        vo.setSalePolicyCode(salePolicyVo.getSalePolicyCode());
        vo.setSalePolicyName(salePolicyVo.getSalePolicyName());
        vo.setValidStartTime(salePolicyVo.getValidStartTime());
        vo.setValidEndTime(salePolicyVo.getValidEndTime());
        vo.setDescription(salePolicyVo.getDescription());
        vo.setLabel(salePolicyVo.getLabel());
        policyVoList.add(vo);
      }
      map.put(productCode, policyVoList);
    }
    return map;
  }
}
