package com.biz.crm.dms.admin.web.report.mall.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.admin.web.report.mall.service.MallOrderVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.MallOrderDetailVo;
import com.biz.crm.dms.admin.web.report.mall.vo.MallOrderVo;
import com.biz.crm.dms.business.order.local.entity.Order;
import com.biz.crm.dms.business.order.local.entity.OrderDetail;
import com.biz.crm.dms.business.order.local.service.OrderService;
import com.biz.crm.dms.business.order.local.service.assist.OrderAssist;
import com.biz.crm.dms.business.order.sdk.dto.CustomerOrderPageDto;
import com.biz.crm.dms.business.order.sdk.service.OrderVoService;
import com.biz.crm.dms.business.order.sdk.vo.OrderDetailVo;
import com.biz.crm.dms.business.order.sdk.vo.OrderVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 商城订单服务impl签证官
 *
 * @author hefan
 * @date 2022/05/14
 */
@Service
public class MallOrderVoServiceImpl implements MallOrderVoService {

  @Autowired(required = false)
  private OrderVoService orderVoService;

  @Autowired(required = false)
  private ProductVoService productVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public Page<MallOrderVo> findByCustomerOrderPageDto(Pageable pageable, CustomerOrderPageDto customerOrderPageDto) {
    Page<OrderVo> page = orderVoService.findByCustomerOrderPageDto(pageable, customerOrderPageDto);
    Page<MallOrderVo> voPage = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
    List<OrderVo> records = page.getRecords();
    // - 给每个sku填充图片
    if (CollectionUtils.isEmpty(records)) {
      return voPage;
    }
    // 
    List<String> productCodes = Lists.newLinkedList();
    for (OrderVo record : records) {
      List<OrderDetailVo> orderDetails = record.getOrderDetails();
      for (OrderDetailVo orderDetail : orderDetails) {
        String goodsCode = orderDetail.getGoodsCode();
        productCodes.add(goodsCode);
      }
    }
    List<ProductVo> productList = productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
    Map<String, ProductVo> productCodeToVoMap = new HashMap<>(productList.size());
    for (ProductVo productVo : productList) {
      productCodeToVoMap.put(productVo.getProductCode(), productVo);
    }

    List<MallOrderVo> mallOrderVos = (List<MallOrderVo>) this.nebulaToolkitService.copyCollectionByBlankList(records, OrderVo.class, MallOrderVo.class, HashSet.class, LinkedList.class);

    for (MallOrderVo mallOrderVo : mallOrderVos) {
      List<MallOrderDetailVo> orderDetails = mallOrderVo.getOrderDetails();
      for (MallOrderDetailVo orderDetail : orderDetails) {
        String goodsCode = orderDetail.getGoodsCode();
        ProductVo productVo = productCodeToVoMap.get(goodsCode);
        if (productVo == null) {
          continue;
        }
        orderDetail.setPictureMediaList(OrderAssist.getFileVos(productVo.getPictureMediaList()));
        orderDetail.setVideoMediaList(OrderAssist.getFileVos(productVo.getVideoMediaList()));
      }
    }
    voPage.setRecords(mallOrderVos);
    return voPage;
  }

  @Autowired(required = false)
  private OrderService orderService;

  @Override
  public MallOrderVo findById(String id) {
    Order order = this.orderService.findById(id);
    // - 给每个sku填充图片
    List<String> productCodes = Lists.newLinkedList();
    List<OrderDetail> orderDetails = order.getOrderDetails();
    for (OrderDetail orderDetail : orderDetails) {
      String goodsCode = orderDetail.getGoodsCode();
      productCodes.add(goodsCode);
    }
    List<ProductVo> productList = productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
    Map<String, ProductVo> productCodeToVoMap = new HashMap<>(productList.size());
    for (ProductVo productVo : productList) {
      productCodeToVoMap.put(productVo.getProductCode(), productVo);
    }
    MallOrderVo mallOrderVo = this.nebulaToolkitService.copyObjectByBlankList(order, MallOrderVo.class, HashSet.class, LinkedList.class);
    List<MallOrderDetailVo> orderDetailList = mallOrderVo.getOrderDetails();
    for (MallOrderDetailVo orderDetail : orderDetailList) {
      String goodsCode = orderDetail.getGoodsCode();
      ProductVo productVo = productCodeToVoMap.get(goodsCode);
      orderDetail.setPictureMediaList(OrderAssist.getFileVos(productVo.getPictureMediaList()));
      orderDetail.setVideoMediaList(OrderAssist.getFileVos(productVo.getVideoMediaList()));
      orderDetail.setIsShelf(productVo.getIsShelf());
    }
    return mallOrderVo;

  }
}
