package com.biz.crm.dms.admin.web.report.mall.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.dms.admin.web.report.mall.dto.HomePageProductPageDto;
import com.biz.crm.dms.admin.web.report.mall.service.MallProductSpuVoService;
import com.biz.crm.dms.admin.web.report.mall.vo.MallProductSkuVo;
import com.biz.crm.dms.admin.web.report.mall.vo.MallProductSpuVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.AllowSaleListDmsPaginationDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListDmsVoService;
import com.biz.crm.dms.business.allow.sale.sdk.list.vo.AllowSaleListDmsVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuRelateSkuVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * 商城产品spu vo服务impl
 *
 * @author hefan
 * @date 2022/05/17
 */
@Service
public class MallProductSpuVoServiceImpl implements MallProductSpuVoService {

  @Autowired(required = false)
  private AllowSaleListDmsVoService allowSaleListDmsVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private ProductVoService productVoService;

  @Override
  public Page<MallProductSpuVo> findByConditions(Pageable pageable, HomePageProductPageDto dto) {
    String customerCode = dto.getCustomerCode();
    // -查询允销商品
    AllowSaleListDmsPaginationDto allowSaleDto = new AllowSaleListDmsPaginationDto();
    allowSaleDto.setKeyword(dto.getKeyword());
    allowSaleDto.setBusinessCode(customerCode);
    allowSaleDto.setProductLevelCode(dto.getProductLevelCode());
    allowSaleDto.setSpuTagList(dto.getSpuTagList());
    allowSaleDto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
    Page<AllowSaleListDmsVo> allowPage = allowSaleListDmsVoService.findByConditions(pageable, allowSaleDto);
    // -查询结果判断
    Page<MallProductSpuVo> page;
    if (allowPage == null) {
      page = new Page<>(pageable.getPageNumber(), pageable.getPageSize(), 0);
      return page;
    } else {
      page = new Page<>(allowPage.getCurrent(), allowPage.getSize(), allowPage.getTotal());
    }
    List<AllowSaleListDmsVo> records = allowPage.getRecords();
    if (CollectionUtils.isEmpty(records)) {
      return page;
    }
    // -查询到的sku 和 spu
    int size = records.size();
    Collection<String> spuCodes = new ArrayList<>(size);
    List<String> productCodes = new ArrayList<>(size << 2);
    for (AllowSaleListDmsVo record : records) {
      spuCodes.add(record.getSpuCode());
      List<ProductSpuRelateSkuVo> productList = record.getProductList();
      for (ProductSpuRelateSkuVo skuvo : productList) {
        String productCode = skuvo.getProductCode();
        productCodes.add(productCode);
      }
    }
    // 查询sku的图片  规格详情
    List<ProductVo> productList = productVoService.findDetailsByIdsOrProductCodes(null, productCodes);
    Map<String, ProductVo> productCodeToVoMap = new HashMap<>(productList.size());
    for (ProductVo productVo : productList) {
      productCodeToVoMap.put(productVo.getProductCode(), productVo);
    }
    // -构造返回内容
    List<MallProductSpuVo> list = new ArrayList<>(size);
    for (AllowSaleListDmsVo record : records) {
      MallProductSpuVo mallProductSpuVo = nebulaToolkitService.copyObjectByBlankList(record, MallProductSpuVo.class, HashSet.class, LinkedList.class, "priceShowList");
      mallProductSpuVo.setPriceShowList(record.getPriceShowList());
      List<MallProductSkuVo> skus = mallProductSpuVo.getProductList();
      for (MallProductSkuVo skuVo : skus) {
        String skuCode = skuVo.getProductCode();
        ProductVo productVo = productCodeToVoMap.get(skuCode);
        skuVo.setPictureMediaList(productVo.getPictureMediaList());
        skuVo.setVideoMediaList(productVo.getVideoMediaList());
        skuVo.setIsShelf(productVo.getIsShelf());
        skuVo.setProductLevelName(productVo.getProductLevelName());
        skuVo.setProductName(productVo.getProductName());
        skuVo.setProductType(productVo.getProductType());
        skuVo.setSpec(productVo.getSpec());
        skuVo.setUnite(productVo.getSaleUnit());
      }
      list.add(mallProductSpuVo);
    }
    page.setRecords(list);
    return page;
  }
}
