package com.biz.crm.dms.admin.web.report.mall.vo;

import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuIntroductionVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuMediaVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuTagVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 首页产品
 *
 * @author hefan
 * @date 2022/04/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "首页产品")
public class HomePageProductVo {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /** 商品spu名称 */
  @ApiModelProperty("商品spu名称")
  private String spuName;

  /** 价格展示 */
  @ApiModelProperty("价格展示")
  private List<BigDecimal> priceShowList;

  /** 商品标签 */
  @ApiModelProperty("商品标签")
  private List<ProductSpuTagVo> tagList;

  /** 关联的商品sku明细 */
  @ApiModelProperty("关联的商品sku明细")
  private List<HomePageProductSkuVo> productList;

  /** 关联的图片明细 */
  @ApiModelProperty("关联的图片明细")
  private List<ProductSpuMediaVo> pictureList;

  /** 关联的视频明细 */
  @ApiModelProperty("关联的视频明细")
  private List<ProductSpuMediaVo> videoList;

  /** 商品spu详情介绍 */
  @ApiModelProperty("商品spu详情介绍")
  private ProductSpuIntroductionVo introduction;

  /**
   * 是否收藏
   */
  @ApiModelProperty("是否收藏")
  private boolean isFavorite = false;

}
