package com.biz.crm.dms.admin.web.report.mall.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 主页sku的促销政策vo
 *
 * @author hefan
 * @date 2022/04/20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "主页sku的促销政策vo")
public class HomePageSkuPolicyVo {

  /**
   * 关键的优惠政策模板类型
   * @return
   */
  @ApiModelProperty("关键的优惠政策模板类型")
  private String type;

  /**
   * 促销编码（一旦创建，不允许修改），不输入就是系统生成(按照租户生成)
   */
  @ApiModelProperty("促销编码")
  private String salePolicyCode;

  /**
   * 促销名称
   */
  @ApiModelProperty("促销名称")
  private String salePolicyName;

  /**
   * 可能的有效期起（包括）
   */
  @ApiModelProperty("可能的有效期起（包括）")
  private Date validStartTime;

  /**
   * 可能的有效期止（包括）
   */
  @ApiModelProperty("可能的有效期止（包括）")
  private Date validEndTime;

  /**
   * 优惠政策中文描述信息（允许最大200字）
   */
  @ApiModelProperty("优惠政策中文描述信息（允许最大200字）")
  private String description;

  /**
   * 促销政策简称
   */
  @ApiModelProperty("促销政策简称")
  private String label;


}
