package com.biz.crm.dms.admin.web.report.mall.vo;

import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuMediaVo;
import com.biz.crm.mdm.business.product.spu.sdk.vo.ProductSpuTagVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商城产品spu
 *
 * @author hefan
 * @date 2022/05/17
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "商品SPU")
public class MallProductSpuVo {

  /** 商品spu编码 */
  @ApiModelProperty("商品spu编码")
  private String spuCode;

  /** 商品spu名称 */
  @ApiModelProperty("商品spu名称")
  private String spuName;

  /** 价格展示 */
  @ApiModelProperty("价格展示")
  private List<BigDecimal> priceShowList;

  /** 商品标签 */
  @ApiModelProperty("商品标签")
  private List<ProductSpuTagVo> tagList;

  /** 关联的商品sku明细 */
  @ApiModelProperty("关联的商品sku明细")
  private List<MallProductSkuVo> productList;

  /** 关联的图片明细 */
  @ApiModelProperty("关联的图片明细")
  private List<ProductSpuMediaVo> pictureList;

  /** 关联的视频明细 */
  @ApiModelProperty("关联的视频明细")
  private List<ProductSpuMediaVo> videoList;



}
