package com.biz.crm.dms.business.allow.sale.local.dimension.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.allow.sale.local.dimension.service.DimensionService;
import com.biz.crm.dms.business.allow.sale.sdk.dimension.vo.DimensionDictVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 允销规则维度信息
 *
 * @author sunx
 * @date 2021/11/24
 */
@Slf4j
@Api(tags = "允销规则维度信息: DimensionDictVo: 允销规则维度信息")
@RestController
@RequestMapping(value = {"/v1/allowSaleRule/allowSaleRuleDimension"})
public class AllowSaleRuleDimensionController {

  @Autowired(required = false) private DimensionService dimensionService;

  /**
   * 维度下拉
   *
   * @return
   */
  @ApiOperation(value = "维度下拉")
  @GetMapping(value = {"/findDimensionDictVoList"})
  public Result<List<DimensionDictVo>> findDimensionDictVoList() {
    try {
      return Result.ok(this.dimensionService.findDimensionDictVoList());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
