package com.biz.crm.dms.business.allow.sale.local.dimension.detail.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.entity.AllowSaleRuleDetail;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.mapper.AllowSaleRuleDetailMapper;
import com.biz.crm.dms.business.allow.sale.local.dimension.detail.model.DetailRelateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 允销规则关联的(组织维度)终端或经销商信息(repository)
 *
 * @author sunx
 * @date 2021-11-19 15:17:00
 */
@Component
public class AllowSaleRuleDetailRepository
    extends ServiceImpl<AllowSaleRuleDetailMapper, AllowSaleRuleDetail> {

  private static final Integer SIZE = 1000;

  /**
   * 根据规则编码获取配置信息
   *
   * @param ruleCodeList 规则编码集合
   * @return
   */
  public List<AllowSaleRuleDetail> findByRuleCodes(List<String> ruleCodeList) {
    List<AllowSaleRuleDetail> list = Lists.newLinkedList();
    for (List<String> item : Lists.partition(ruleCodeList, SIZE)) {
      final List<AllowSaleRuleDetail> cur =
          this.lambdaQuery()
              .eq(AllowSaleRuleDetail::getTenantCode, TenantUtils.getTenantCode())
              .in(AllowSaleRuleDetail::getRuleCode, item)
              .list();
      if (CollectionUtils.isEmpty(cur)) {
        continue;
      }
      list.addAll(cur);
    }
    return list;
  }

  /**
   * 根据规则编码删除配置信息
   *
   * @param ruleCode 规则编码
   */
  public void deleteByRuleCode(String ruleCode) {
    LambdaQueryWrapper<AllowSaleRuleDetail> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(AllowSaleRuleDetail::getTenantCode, TenantUtils.getTenantCode())
        .eq(AllowSaleRuleDetail::getRuleCode, ruleCode);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据维度类型+关联业务编码获取配置信息
   *
   * @param dimensionType 维度类型
   * @param relateCodeList 关联业务编码集合
   * @return
   */
  public List<DetailRelateVo> findByDimensionTypeAndRelateCodes(
      String dimensionType, List<String> relateCodeList) {
    List<DetailRelateVo> list = Lists.newLinkedList();
    for (List<String> item : Lists.partition(relateCodeList, SIZE)) {
      final List<DetailRelateVo> cur =
          this.baseMapper.findByDimensionTypeAndRelateCodes(
              dimensionType,
              item,
              TenantUtils.getTenantCode(),
              EnableStatusEnum.ENABLE.getCode(),
              DelFlagStatusEnum.NORMAL.getCode());
      if (CollectionUtils.isEmpty(cur)) {
        continue;
      }
      list.addAll(cur);
    }
    return list;
  }
}
