package com.biz.crm.dms.business.allow.sale.local.element.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 要素可购清单
 * @author: rentao
 * @date: 2021/11/25 10:23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("dms_allow_sale_element")
@Table(
    name = "dms_allow_sale_element",
    indexes = {
      @Index(name = "dms_allow_sale_element1", columnList = "contract_code"),
      @Index(name = "dms_allow_sale_element2", columnList = "product_level_code"),
      @Index(name = "dms_allow_sale_element3", columnList = "product_code"),
    })
@ApiModel(value = "AllowSaleElement", description = "允销清单要素信息")
@org.hibernate.annotations.Table(appliesTo = "dms_allow_sale_element", comment = "允销清单要素信息")
public class AllowSaleElement extends TenantFlagOpEntity {

  /** 合同编码 */
  @ApiModelProperty("合同编码")
  @TableField(value = "contract_code")
  @Column(name = "contract_code", length = 64, columnDefinition = "varchar(64) COMMENT '合同编码'")
  private String contractcode;

  /** 产品层级编码 */
  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  @Column(
      name = "product_level_code",
      length = 64,
      columnDefinition = "varchar(64) COMMENT '产品层级编码'")
  private String productLevelCode;

  /** 产品层级名称 */
  @ApiModelProperty("产品层级名称")
  @TableField(value = "product_level_name")
  @Column(
      name = "product_level_name",
      length = 128,
      columnDefinition = "varchar(128) COMMENT '产品层级名称'")
  private String productLevelName;

  /** 产品sku编码 */
  @ApiModelProperty("产品sku编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 128, columnDefinition = "varchar(128) COMMENT '产品sku编码'")
  private String productCode;

  /** 产品sku名称 */
  @ApiModelProperty("产品sku名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 128, columnDefinition = "varchar(128) COMMENT '产品sku名称'")
  private String productName;

  /** 可购类型 */
  @ApiModelProperty("可购类型 suk 层级")
  @TableField(value = "allow_sale_type")
  @Column(
      name = "allow_sale_type",
      length = 10,
      columnDefinition = "varchar(10) COMMENT '可购类型 suk 层级'")
  private String allowSaleType;
}
