package com.biz.crm.dms.business.allow.sale.local.element.service.internal;

import com.biz.crm.dms.business.allow.sale.local.element.entity.AllowSaleElement;
import com.biz.crm.dms.business.allow.sale.local.element.repository.AllowSaleElementRepository;
import com.biz.crm.dms.business.allow.sale.local.element.service.AllowSaleElementService;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementVo;
import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleElementEnums;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

/**
 * @description: 可购要素service
 * @author: rentao
 * @date: 2021/11/25 10:25
 */
@Slf4j
@Service
public class AllowSaleElementServiceImpl implements AllowSaleElementService {

  @Autowired(required = false) private AllowSaleElementRepository allowSaleElementRepository;

  @Autowired(required = false) private NebulaToolkitService nebulaToolkitService;

  @Override
  public AllowSaleElementDataVo findByContractCode(String contractcode) {
    if (StringUtils.isBlank(contractcode)) {
      return null;
    }
    List<AllowSaleElement> allowSaleElements =
        this.allowSaleElementRepository.findByContractCode(contractcode);
    if (CollectionUtils.isEmpty(allowSaleElements)) {
      return null;
    }
    AllowSaleElementDataVo vo = new AllowSaleElementDataVo();
    List<AllowSaleElementVo> contractVos =
        (List<AllowSaleElementVo>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                allowSaleElements,
                AllowSaleElement.class,
                AllowSaleElementVo.class,
                HashSet.class,
                ArrayList.class);
    Map<String, List<AllowSaleElementVo>> elementVoMap =
        contractVos.stream().collect(Collectors.groupingBy(AllowSaleElementVo::getAllowSaleType));
    vo.setAllowSaleMap(elementVoMap);
    return vo;
  }

  @Override
  public List<AllowSaleElement> findByContractCodeList(List<String> contractCodeList) {
    if (CollectionUtils.isEmpty(contractCodeList)) {
      return null;
    }
    return this.allowSaleElementRepository.findByContractCodeList(contractCodeList);
  }

  @Override
  @Transactional
  public AllowSaleElementDataVo createAllowSaleElement(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode) {
    this.validateSaveOrUpdate(contractCode, allowSaleElementDataVo);
    List<AllowSaleElementVo> allowSaleElementVos = new ArrayList<>();
    allowSaleElementDataVo.getAllowSaleMap().forEach((k, v) -> allowSaleElementVos.addAll(v));
    // 校验入参
    List<AllowSaleElement> allowSaleElements =
        (List<AllowSaleElement>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                allowSaleElementVos,
                AllowSaleElementVo.class,
                AllowSaleElement.class,
                HashSet.class,
                ArrayList.class);
    if (!CollectionUtils.isEmpty(allowSaleElements)) {
      allowSaleElements.forEach(
          allowSaleElement -> {
            allowSaleElement.setTenantCode(TenantUtils.getTenantCode());
            allowSaleElement.setContractcode(contractCode);
          });
    }
    this.allowSaleElementRepository.saveBatch(allowSaleElements);
    return allowSaleElementDataVo;
  }

  @Override
  @Transactional
  public AllowSaleElementDataVo updateAllowSaleElement(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode) {
    this.validateSaveOrUpdate(contractCode, allowSaleElementDataVo);
    List<AllowSaleElementVo> allowSaleElementVos = new ArrayList<>();
    allowSaleElementDataVo.getAllowSaleMap().forEach((k, v) -> allowSaleElementVos.addAll(v));
    this.allowSaleElementRepository.deleteByContractCode(contractCode);
    List<AllowSaleElement> allowSaleElements =
        (List<AllowSaleElement>)
            this.nebulaToolkitService.copyCollectionByWhiteList(
                allowSaleElementVos,
                AllowSaleElementVo.class,
                AllowSaleElement.class,
                HashSet.class,
                ArrayList.class);
    if (!CollectionUtils.isEmpty(allowSaleElements)) {
      allowSaleElements.forEach(
          allowSaleElement -> {
            allowSaleElement.setId(null);
            allowSaleElement.setTenantCode(TenantUtils.getTenantCode());
            allowSaleElement.setContractcode(contractCode);
          });
    }
    this.allowSaleElementRepository.saveBatch(allowSaleElements);
    return allowSaleElementDataVo;
  }

  private void validateSaveOrUpdate(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo) {
    // 校验入参
    Validate.notBlank(contractCode, "合同编码不能为空");
    Validate.notNull(allowSaleElementDataVo, "合同细则为空");
    Validate.notNull(allowSaleElementDataVo.getAllowSaleMap(), "合同可购清单不能为空");
    allowSaleElementDataVo
        .getAllowSaleMap()
        .forEach(
            (k, v) -> {
              if (!CollectionUtils.isEmpty(v)) {
                v.forEach(
                    allowSaleElementVo -> {
                      Validate.notNull(allowSaleElementVo.getAllowSaleType(), "合同可购清单类型不能为空");
                      Validate.isTrue(
                          AllowSaleElementEnums.exists(allowSaleElementVo.getAllowSaleType()),
                          "合同可购清单类型不存在");
                      if (AllowSaleElementEnums.PRODUCT
                          .getCode()
                          .equals(allowSaleElementVo.getAllowSaleType())) {
                        Validate.notNull(allowSaleElementVo.getProductCode(), "合同可购清单产品编码不存在");
                        Validate.notNull(allowSaleElementVo.getProductName(), "合同可购清单产品名称不存在");
                      }
                      if (AllowSaleElementEnums.PRODUCT_LEVEL
                          .getCode()
                          .equals(allowSaleElementVo.getAllowSaleType())) {
                        Validate.notNull(
                            allowSaleElementVo.getProductLevelCode(), "合同可购清单产品层级编码不存在");
                        Validate.notNull(
                            allowSaleElementVo.getProductLevelName(), "合同可购清单产品层级名称不存在");
                      }
                    });
              }
            });
  }
}
