package com.biz.crm.dms.business.allow.sale.local.element.service.register;

import com.biz.crm.dms.business.allow.sale.local.element.service.AllowSaleElementService;
import com.biz.crm.dms.business.allow.sale.sdk.element.vo.AllowSaleElementDataVo;
import com.biz.crm.dms.business.contract.sdk.register.contractelement.ContractElementRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @description: 可购要素注册
 * @author: rentao
 * @date: 2021/11/25 10:25
 */
@Slf4j
@Service("allowSaleElementRegister")
public class AllowSaleElementRegisterImpl
    implements ContractElementRegister<AllowSaleElementDataVo> {

  @Autowired(required = false) private AllowSaleElementService allowSaleElementService;

  /**
  * 合同要素编码
  * */
  private static final String CONTRACT_ELEMENT_CODE = "allowSaleElementRegister";

  /**
   * 合同要素组件名称
   * */
  private static final String CONTRACT_ELEMENT_COMPONENT_NAME = "dms-contract-manage-buyablegoods";

  /**
   * 合同要素名称
   * */
  private static final String CONTRACT_ELEMENT_NAME = "可购清单";

  /**
   * 合同要素排序
   * */
  private static final Integer ELEMENT_SORT = 1;

  @Override
  public String getContractElementName() {
    return CONTRACT_ELEMENT_NAME;
  }

  @Override
  public String getContractElementCode() {
    return CONTRACT_ELEMENT_CODE;
  }

  @Override
  public String getContractElementComponentName() {
    return CONTRACT_ELEMENT_COMPONENT_NAME;
  }

  @Override
  public Integer getElementSort() {
    return ELEMENT_SORT;
  }

  @Override
  public Class<AllowSaleElementDataVo> getContractElementClass() {
    return AllowSaleElementDataVo.class;
  }

  @Override
  public AllowSaleElementDataVo getByContractCode(String contractcode) {
    return this.allowSaleElementService.findByContractCode(contractcode);
  }

  @Override
  @Transactional
  public AllowSaleElementDataVo onRequestContractCreate(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode) {
    return this.allowSaleElementService.createAllowSaleElement(
        contractCode, allowSaleElementDataVo, indexCode);
  }

  @Override
  @Transactional
  public AllowSaleElementDataVo onRequestContractUpdate(
      String contractCode, AllowSaleElementDataVo allowSaleElementDataVo, Integer indexCode) {
    return this.allowSaleElementService.updateAllowSaleElement(
        contractCode, allowSaleElementDataVo, indexCode);
  }
}
